/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.zkoss.chart.Axis;
import org.zkoss.chart.Chart;
import org.zkoss.chart.ChartsClickEvent;
import org.zkoss.chart.ChartsEvent;
import org.zkoss.chart.ChartsSelectionEvent;
import org.zkoss.chart.Color;
import org.zkoss.chart.Credits;
import org.zkoss.chart.Drilldown;
import org.zkoss.chart.Exporting;
import org.zkoss.chart.Labels;
import org.zkoss.chart.Legend;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.Loading;
import org.zkoss.chart.Navigation;
import org.zkoss.chart.NoData;
import org.zkoss.chart.Options;
import org.zkoss.chart.Pane;
import org.zkoss.chart.PlotData;
import org.zkoss.chart.PlotEngine;
import org.zkoss.chart.Point;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.Series;
import org.zkoss.chart.Subtitle;
import org.zkoss.chart.Theme;
import org.zkoss.chart.Title;
import org.zkoss.chart.Tooltip;
import org.zkoss.chart.XAxis;
import org.zkoss.chart.YAxis;
import org.zkoss.chart.impl.AreaPlotImpl;
import org.zkoss.chart.impl.AreaRangePlotImpl;
import org.zkoss.chart.impl.AreaSplinePlotImpl;
import org.zkoss.chart.impl.AreaSplineRangePlotImpl;
import org.zkoss.chart.impl.BarPlotImpl;
import org.zkoss.chart.impl.BubblePlotImpl;
import org.zkoss.chart.impl.ColumnPlotImpl;
import org.zkoss.chart.impl.ColumnRangePlotImpl;
import org.zkoss.chart.impl.ErrorBarPlotImpl;
import org.zkoss.chart.impl.FunnelPlotImpl;
import org.zkoss.chart.impl.GaugePlotImpl;
import org.zkoss.chart.impl.LinePlotImpl;
import org.zkoss.chart.impl.PiePlotImpl;
import org.zkoss.chart.impl.PolarPlotImpl;
import org.zkoss.chart.impl.ScatterPlotImpl;
import org.zkoss.chart.impl.SplinePlotImpl;
import org.zkoss.chart.impl.WaterfallPlotImpl;
import org.zkoss.chart.model.CategoryModel;
import org.zkoss.chart.model.ChartsDataEvent;
import org.zkoss.chart.model.ChartsDataListener;
import org.zkoss.chart.model.ChartsModel;
import org.zkoss.chart.model.ChartsModelProxy;
import org.zkoss.chart.model.DialChartsDataEvent;
import org.zkoss.chart.model.DialChartsDataEventImpl;
import org.zkoss.chart.model.DialModel;
import org.zkoss.chart.model.SingleValueCategoryModel;
import org.zkoss.chart.model.XYModel;
import org.zkoss.chart.plotOptions.PlotOptions;
import org.zkoss.chart.util.JSFunction;
import org.zkoss.json.JSONValue;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.ChartModel;
import org.zkoss.zul.impl.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Charts
extends AbstractComponent {
    private static final long serialVersionUID = 20140108153712L;
    public static final String AREA = "area";
    public static final String AREA_RANGE = "arearange";
    public static final String AREA_SPLINE = "areaspline";
    public static final String AREA_SPLINE_RANGE = "areasplinerange";
    public static final String BAR = "bar";
    public static final String BOX_PLOT = "boxplot";
    public static final String BUBBLE = "bubble";
    public static final String COLUMN = "column";
    public static final String COLUMN_RANGE = "columnrange";
    public static final String ERROR_BAR = "errorbar";
    public static final String FUNNEL = "funnel";
    public static final String GAUGE = "gauge";
    public static final String LINE = "line";
    public static final String PIE = "pie";
    public static final String SCATTER = "scatter";
    public static final String SERIES = "series";
    public static final String SPLINE = "spline";
    public static final String WATERFALL = "waterfall";
    public static final String POLAR = "polar";
    protected String _zclass;
    private boolean _smartDrawChart;
    private ChartsDataListener _dataListener;
    private ChartsModel _model;
    private PlotData _plotData;
    private Options _options;
    private Theme _theme;
    private transient Set<Point> _selPoints;
    private static final String ZKCHARTS_LOCK = "org.zkoss.chart.rt.lock.key";
    private static final Random _RGEN;
    private List<JavaScriptValue> _befInvoke = new LinkedList<JavaScriptValue>();
    private static final String ATTR_ON_SYNC_MODEL_LATER = "org.zkoss.chart.onSyncModelLater";
    private static String WRAP_FUNC;
    private static String RETURN_FUNC;
    private transient PlotEngine _chartImpl;
    private boolean _rendered;
    private LinkedList<Series> _drilldownLevels;

    boolean checkLock() {
        return _RGEN.nextInt() > 0 || "true".equals(Library.getProperty((String)ZKCHARTS_LOCK));
    }

    public Charts() {
        this._selPoints = new HashSet<Point>();
    }

    public PlotData getPlotData() {
        if (this._plotData == null) {
            this._plotData = new PlotData(this);
        }
        return this._plotData;
    }

    public Drilldown getDrilldown() {
        return this.getPlotData().getDrilldown();
    }

    public void setOptions(Options options) {
        if (options == null) {
            throw new WrongValueException("Global options cannot be null!");
        }
        this._options = options;
        this.invalidate();
    }

    public void setDateFormat(String format, Number time, boolean capitalize) {
        this.addBeforeInvokeScript("Highcharts.dateFormat('" + JSONValue.toJSONString((Object)format) + "', " + JSONValue.toJSONString((Object)time) + ", " + JSONValue.toJSONString((boolean)capitalize) + ")");
        this.invalidate();
    }

    public void setNumberFormat(Number number, Number decimals, String decimalPoint, String thousandsSep) {
        this.addBeforeInvokeScript(String.format("Highcharts.numberFormat(%1$s,%2$s,%3$s,%4$s)", JSONValue.toJSONString((Object)number), JSONValue.toJSONString((Object)decimals), JSONValue.toJSONString((Object)decimalPoint), JSONValue.toJSONString((Object)thousandsSep)));
        this.invalidate();
    }

    private void addBeforeInvokeScript(String script) {
        JSFunction jsFunction = new JSFunction();
        jsFunction.evalJavascript(script);
        this._befInvoke.add(new JavaScriptValue(jsFunction.toExecFunction()));
    }

    public void setColors(List<Color> colors) {
        this.getPlotData().setColors(colors);
    }

    public void setColors(String ... source) {
        Color[] colors = new Color[source.length];
        int i = 0;
        for (String s : source) {
            colors[i++] = new Color(s);
        }
        this.setColors(Arrays.asList(colors));
    }

    public List<Color> getColors() {
        return this.getPlotData().getColors();
    }

    public void setTheme(Theme theme) {
        if (theme == null) {
            throw new WrongValueException("Theme options cannot be null!");
        }
        this._theme = theme;
        this.invalidate();
    }

    public Theme getTheme() {
        return this._theme;
    }

    public Options getOptions() {
        return this._options;
    }

    public ChartsModel getModel() {
        return this._model;
    }

    public void setModel(ChartsModel model) {
        if (this._model != model) {
            if (this._model != null) {
                this._model.removeChartsDataListener(this._dataListener);
                int i = this._plotData.getSeriesSize();
                while (--i >= 0) {
                    this._plotData.getSeries(i).remove();
                }
                this.invalidate();
            }
            this._model = model;
            this.initDataListener();
            this.smartDrawChart();
        }
    }

    public void setModel(ChartModel model) {
        if (model != null) {
            String version = WebApps.getCurrent().getVersion().replace(".", "");
            int f = Integer.parseInt(String.valueOf(version.charAt(0)));
            if (f < 7) {
                throw new IllegalArgumentException("The version of ChartModel is not supported, please use ZK 7.0.1+ version or new ChartsModel instead. ");
            }
            if (f == 7) {
                int s = Integer.parseInt(String.valueOf(version.charAt(1)));
                int t = Integer.parseInt(String.valueOf(version.charAt(2)));
                if (s == 0 && t == 0) {
                    throw new IllegalArgumentException("The version of ChartModel is not supported, please use ZK 7.0.1+ version or new ChartsModel instead. ");
                }
            }
            this.setModel(ChartsModelProxy.getInstance(model));
        } else {
            this.setModel((ChartsModel)null);
        }
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new MyChartsDataListener();
        }
        this._model.addChartsDataListener(this._dataListener);
    }

    private void postonSyncModelLater() {
        if (this.getAttribute(ATTR_ON_SYNC_MODEL_LATER) == null) {
            this.setAttribute(ATTR_ON_SYNC_MODEL_LATER, Boolean.TRUE);
            Events.postEvent((String)"onSyncModel", (Component)this, null);
        }
    }

    public void onSyncModel() {
        this.removeAttribute(ATTR_ON_SYNC_MODEL_LATER);
        if (this._model != null) {
            int pSize = 0;
            boolean rerender = false;
            int size = this.getPlotData().getSeriesSize();
            for (int i = 0; i < size; ++i) {
                if (pSize == 0) {
                    pSize = this.getSeries(i).getData().size();
                    continue;
                }
                List<Point> data = this.getSeries(i).getData();
                if (data == null || pSize == data.size()) continue;
                rerender = true;
                break;
            }
            if (rerender) {
                int i = this._plotData.getSeriesSize();
                while (--i >= 0) {
                    List<Point> data = this._plotData.getSeries(i).getData();
                    if (data == null) continue;
                    data.clear();
                }
                this.smartDrawChart();
            }
        }
    }

    public void showLoading(String text) {
        JSFunction js = new JSFunction();
        js.callFunction("showLoading", text);
        this.smartUpdate("eval", new JavaScriptValue(js.toWrapFunction()), true);
    }

    public void hideLoading() {
        JSFunction js = new JSFunction();
        js.callFunction("hideLoading");
        this.smartUpdate("eval", new JavaScriptValue(js.toWrapFunction()), true);
    }

    public void print() {
        JSFunction js = new JSFunction();
        js.callFunction("print");
        this.smartUpdate("eval", new JavaScriptValue(js.toWrapFunction()), true);
    }

    public void setType(String type) {
        Chart chart = this.getChart();
        String oldType = chart.getType();
        if (oldType != type) {
            if (POLAR.equals(type)) {
                this.getChart().setPolar(true);
            }
            chart.setType(type);
            this._chartImpl = null;
            this.smartDrawChart();
        }
    }

    public String getType() {
        return this.getChart().getType();
    }

    public void setAlignTicks(boolean alignTicks) {
        this.getChart().setAlignTicks(alignTicks);
    }

    public boolean isAlignTicks() {
        return this.getChart().isAlignTicks();
    }

    public void setAnimation(boolean animation) {
        this.getChart().setAnimation(animation);
    }

    public boolean isAnimation() {
        return this.getChart().isAnimation();
    }

    public void setIgnoreHiddenSeries(boolean ignoreHiddenSeries) {
        this.getChart().setIgnoreHiddenSeries(ignoreHiddenSeries);
    }

    public boolean isIgnoreHiddenSeries() {
        return this.getChart().isIgnoreHiddenSeries();
    }

    public void setBackgroundColor(String backgroundColor) {
        this.getChart().setBackgroundColor(backgroundColor);
    }

    public void setBackgroundColor(LinearGradient gradient) {
        this.getChart().setBackgroundColor(gradient);
    }

    public void setBackgroundColor(RadialGradient gradient) {
        this.getChart().setBackgroundColor(gradient);
    }

    public void setBackgroundColor(Color color) {
        this.getChart().setBackgroundColor(color);
    }

    public Color getBackgroundColor() {
        return this.getChart().getBackgroundColor();
    }

    public void setBorderColor(String borderColor) {
        this.getChart().setBorderColor(borderColor);
    }

    public void setBorderColor(LinearGradient borderColor) {
        this.getChart().setBorderColor(borderColor);
    }

    public void setBorderColor(RadialGradient borderColor) {
        this.getChart().setBorderColor(borderColor);
    }

    public void setBorderColor(Color borderColor) {
        this.getChart().setBorderColor(borderColor);
    }

    public Color getBorderColor() {
        return this.getChart().getBorderColor();
    }

    public void setBorderRadius(Number borderRadius) {
        this.getChart().setBorderRadius(borderRadius);
    }

    public Number getBorderRadius() {
        return this.getChart().getBorderRadius();
    }

    public void setBorderWidth(Number borderWidth) {
        this.getChart().setBorderWidth(borderWidth);
    }

    public Number getBorderWidth() {
        return this.getChart().getBorderWidth();
    }

    public void setWidth(Number width) {
        this.getChart().setWidth(width);
    }

    public Number getWidth() {
        return this.getChart().getWidth();
    }

    public void setHeight(Number height) {
        this.getChart().setHeight(height);
    }

    public Number getHeight() {
        return this.getChart().getHeight();
    }

    public void setInverted(boolean inverted) {
        this.getChart().setInverted(inverted);
    }

    public boolean isInverted() {
        return this.getChart().isInverted();
    }

    public void setMargin(String margins) {
        int[] margin = Utils.stringToInts((String)margins, (int)0);
        Number[] result = new Number[margin.length];
        int i = 0;
        for (int m : margin) {
            result[i++] = m;
        }
        this.setMargin(result);
    }

    public void setMargin(Number[] margin) {
        this.getChart().setMargin(margin);
    }

    public Number[] getMargin() {
        return this.getChart().getMargin();
    }

    public void setMarginBottom(Number marginBottom) {
        this.getChart().setMarginBottom(marginBottom);
    }

    public Number getMarginBottom() {
        return this.getChart().getMarginBottom();
    }

    public void setMarginLeft(Number marginLeft) {
        this.getChart().setMarginLeft(marginLeft);
    }

    public Number getMarginLeft() {
        return this.getChart().getMarginLeft();
    }

    public void setMarginRight(Number marginRight) {
        this.getChart().setMarginRight(marginRight);
    }

    public Number getMarginRight() {
        return this.getChart().getMarginRight();
    }

    public void setMarginTop(Number marginTop) {
        this.getChart().setMarginTop(marginTop);
    }

    public Number getMarginTop() {
        return this.getChart().getMarginTop();
    }

    public void setPinchType(String pinchType) {
        this.getChart().setPinchType(pinchType);
    }

    public String getPinchType() {
        return this.getChart().getPinchType();
    }

    public void setPlotBackgroundColor(String plotBackgroundColor) {
        this.getChart().setPlotBackgroundColor(plotBackgroundColor);
    }

    public void setPlotBackgroundColor(LinearGradient plotBackgroundColor) {
        this.getChart().setPlotBackgroundColor(plotBackgroundColor);
    }

    public void setPlotBackgroundColor(RadialGradient plotBackgroundColor) {
        this.getChart().setPlotBackgroundColor(plotBackgroundColor);
    }

    public void setPlotBackgroundColor(Color plotBackgroundColor) {
        this.getChart().setPlotBackgroundColor(plotBackgroundColor);
    }

    public Color getPlotBackgroundColor() {
        return this.getChart().getPlotBackgroundColor();
    }

    public void setPlotBackgroundImage(String plotBackgroundImage) {
        this.getChart().setPlotBackgroundImage(plotBackgroundImage);
    }

    public String getPlotBackgroundImage() {
        return this.getChart().getPlotBackgroundImage();
    }

    public void setPlotBorderColor(String plotBorderColor) {
        this.getChart().setPlotBorderColor(plotBorderColor);
    }

    public void setPlotBorderColor(LinearGradient plotBorderColor) {
        this.getChart().setPlotBorderColor(plotBorderColor);
    }

    public void setPlotBorderColor(RadialGradient plotBorderColor) {
        this.getChart().setPlotBorderColor(plotBorderColor);
    }

    public void setPlotBorderColor(Color plotBorderColor) {
        this.getChart().setPlotBorderColor(plotBorderColor);
    }

    public Color getPlotBorderColor() {
        return this.getChart().getPlotBorderColor();
    }

    public void setPlotBorderWidth(Number plotBorderWidth) {
        this.getChart().setPlotBorderWidth(plotBorderWidth);
    }

    public Number getPlotBorderWidth() {
        return this.getChart().getPlotBorderWidth();
    }

    public void setPlotShadow(boolean plotShadow) {
        this.getChart().setPlotShadow(plotShadow);
    }

    public boolean isPlotShadow() {
        return this.getChart().isPlotShadow();
    }

    public void setPolar(boolean polar) {
        this.getChart().setPolar(polar);
    }

    public boolean isPolar() {
        return this.getChart().isPolar();
    }

    public void setReflow(boolean reflow) {
        this.getChart().setReflow(reflow);
    }

    public boolean isReflow() {
        return this.getChart().isReflow();
    }

    public void setSelectionMarkerFill(String selectionMarkerFill) {
        this.getChart().setSelectionMarkerFill(selectionMarkerFill);
    }

    public void setSelectionMarkerFill(LinearGradient selectionMarkerFill) {
        this.getChart().setSelectionMarkerFill(selectionMarkerFill);
    }

    public void setSelectionMarkerFill(RadialGradient selectionMarkerFill) {
        this.getChart().setSelectionMarkerFill(selectionMarkerFill);
    }

    public void setSelectionMarkerFill(Color selectionMarkerFill) {
        this.getChart().setSelectionMarkerFill(selectionMarkerFill);
    }

    public Color getSelectionMarkerFill() {
        return this.getChart().getSelectionMarkerFill();
    }

    public void setShadow(boolean shadow) {
        this.getChart().setShadow(shadow);
    }

    public boolean isShadow() {
        return this.getChart().isShadow();
    }

    public void setShowAxes(boolean showAxes) {
        this.getChart().setShowAxes(showAxes);
    }

    public boolean isShowAxes() {
        return this.getChart().isShowAxes();
    }

    public void setSpacing(String spacings) {
        int[] spacing = Utils.stringToInts((String)spacings, (int)0);
        int i = 0;
        Number[] result = new Number[spacing.length];
        for (int s : spacing) {
            result[i++] = s;
        }
        this.setSpacing(result);
    }

    public void setSpacing(Number[] spacing) {
        this.getChart().setSpacing(spacing);
    }

    public Number[] getSpacing() {
        return this.getChart().getSpacing();
    }

    public void setSpacingBottom(Number spacingBottom) {
        this.getChart().setSpacingBottom(spacingBottom);
    }

    public Number getSpacingBottom() {
        return this.getChart().getSpacingBottom();
    }

    public void setSpacingLeft(Number spacingLeft) {
        this.getChart().setSpacingLeft(spacingLeft);
    }

    public Number getSpacingLeft() {
        return this.getChart().getSpacingLeft();
    }

    public void setSpacingRight(Number spacingRight) {
        this.getChart().setSpacingRight(spacingRight);
    }

    public Number getSpacingRight() {
        return this.getChart().getSpacingRight();
    }

    public void setSpacingTop(Number spacingTop) {
        this.getChart().setSpacingTop(spacingTop);
    }

    public Number getSpacingTop() {
        return this.getChart().getSpacingTop();
    }

    public void setStyle(String style) {
        this.getChart().setStyle(style);
    }

    public <K, V> void setStyle(Map<K, V> style) {
        this.getChart().setStyle(style);
    }

    public <K, V> Map<K, V> getStyle() {
        return this.getChart().getStyle();
    }

    public void setZoomType(String zoomType) {
        this.getChart().setZoomType(zoomType);
    }

    public String getZoomType() {
        return this.getChart().getZoomType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void smartDrawChart() {
        if (this._smartDrawChart || this._model == null) {
            return;
        }
        this._smartDrawChart = true;
        try {
            this.doSmartDraw();
        }
        finally {
            this._smartDrawChart = false;
        }
    }

    public Tooltip getTooltip() {
        return this.getPlotData().getTooltip();
    }

    public void setTooltip(Tooltip tooltip) {
        this.getPlotData().setTooltip(tooltip);
    }

    public Chart getChart() {
        return this.getPlotData().getChart();
    }

    public void setNoData(NoData noData) {
        this.getPlotData().setNoData(noData);
    }

    public NoData getNoData() {
        return this.getPlotData().getNoData();
    }

    public Exporting getExporting() {
        return this.getPlotData().getExporting();
    }

    public void setExporting(Exporting exporting) {
        this.getPlotData().setExporting(exporting);
    }

    public void setCredits(Credits credits) {
        this.getPlotData().setCredits(credits);
    }

    public Credits getCredits() {
        return this.getPlotData().getCredits();
    }

    public void setChart(Chart chart) {
        this.getPlotData().setChart(chart);
    }

    public Pane getPane() {
        return this.getPlotData().getPane();
    }

    public Pane getPane(int index) {
        return this.getPlotData().getPane(index);
    }

    public int getPaneSize() {
        return this.getPlotData().getPaneSize();
    }

    public Legend getLegend() {
        return this.getPlotData().getLegend();
    }

    public Loading getLoading() {
        return this.getPlotData().getLoading();
    }

    public void setLegend(Legend legend) {
        this.getPlotData().setLegend(legend);
    }

    public Labels getLabels() {
        return this.getPlotData().getLabels();
    }

    public void setLabels(Labels labels) {
        this.getPlotData().setLabels(labels);
    }

    public void setNavigation(Navigation navigation) {
        this.getPlotData().setNavigation(navigation);
    }

    public Navigation getNavigation() {
        return this.getPlotData().getNavigation();
    }

    public PlotOptions getPlotOptions() {
        return this.getPlotData().getPlotOptions();
    }

    public void setPlotOptions(PlotOptions plotOptions) {
        this.getPlotData().setPlotOptions(plotOptions);
    }

    public Series getSeries() {
        return this.getPlotData().getSeries();
    }

    public void addSeries(Series series) {
        this.getPlotData().addSeries(series);
    }

    public void addAxis(Axis axis) {
        if (axis instanceof XAxis) {
            this.getPlotData().addXAxis((XAxis)axis);
        } else if (axis instanceof YAxis) {
            this.getPlotData().addYAxis((YAxis)axis);
        }
    }

    public int getSeriesSize() {
        return this.getPlotData().getSeriesSize();
    }

    public Series getSeries(int index) {
        return this.getPlotData().getSeries(index);
    }

    public XAxis getXAxis() {
        return this.getPlotData().getXAxis();
    }

    public XAxis getXAxis(int index) {
        return this.getPlotData().getXAxis(index);
    }

    public int getXAxisSize() {
        return this.getPlotData().getXAxisSize();
    }

    public YAxis getYAxis() {
        return this.getPlotData().getYAxis();
    }

    public YAxis getYAxis(int index) {
        return this.getPlotData().getYAxis(index);
    }

    public int getyAxisSize() {
        return this.getPlotData().getYAxisSize();
    }

    public void setTitle(String title) {
        this.getTitle().setText(title);
    }

    public void setTitle(Title title) {
        this.getPlotData().setTitle(title);
    }

    public Title getTitle() {
        return this.getPlotData().getTitle();
    }

    public Subtitle getSubtitle() {
        return this.getPlotData().getSubtitle();
    }

    public void setSubtitle(String subtitle) {
        this.getSubtitle().setText(subtitle);
    }

    public void setSubtitle(Subtitle subtitle) {
        this.getPlotData().setSubtitle(subtitle);
    }

    public void setEnableZoomSelection(boolean enableZoomSelection) {
        this.getChart().setEnableZoomSelection(enableZoomSelection);
    }

    public boolean isEnableZoomSelection() {
        return this.getChart().isEnableZoomSelection();
    }

    public void addSeriesAsDrilldown(Point point, Series series) {
        this._drilldownLevels.addFirst(series);
        JSFunction returnFunc = new JSFunction();
        returnFunc.callArray("data", point.getSeries().getData().indexOf(point));
        returnFunc.callArray(SERIES, 0);
        JSFunction func = new JSFunction();
        func.callFunction("addSeriesAsDrilldown", new JavaScriptValue(String.format(RETURN_FUNC, returnFunc.reverse())), series);
        this.smartUpdate("eval", new JavaScriptValue(String.format(WRAP_FUNC, func)), true);
    }

    private void doSmartDraw() {
        if (!this.checkLock()) {
            return;
        }
        if (this._model == null) {
            throw new UiException("Chart Model cannot be null!");
        }
        PlotData plotData = this.getPlotEngine().drawPlot(this._model);
        if (!this._plotData.equals(plotData)) {
            this._plotData.merge(plotData);
        }
        this.smartUpdate("plotData", this._plotData);
    }

    private PlotEngine getPlotEngine() {
        if (this._chartImpl != null) {
            return this._chartImpl;
        }
        String type = this.getType();
        if (LINE.equals(type)) {
            this._chartImpl = new LinePlotImpl(this);
        } else if (AREA.equals(type)) {
            this._chartImpl = new AreaPlotImpl(this);
        } else if (PIE.equals(type)) {
            this._chartImpl = new PiePlotImpl(this);
        } else if (BAR.equals(type)) {
            this._chartImpl = new BarPlotImpl(this);
        } else if (COLUMN.equals(type)) {
            this._chartImpl = new ColumnPlotImpl(this);
        } else if (AREA_SPLINE.equals(type)) {
            this._chartImpl = new AreaSplinePlotImpl(this);
        } else if (SCATTER.equals(type)) {
            this._chartImpl = new ScatterPlotImpl(this);
        } else if (BUBBLE.equals(type)) {
            this._chartImpl = new BubblePlotImpl(this);
        } else if (WATERFALL.equals(type)) {
            this._chartImpl = new WaterfallPlotImpl(this);
        } else if (POLAR.equals(type)) {
            this._chartImpl = new PolarPlotImpl(this);
        } else if (SPLINE.equals(type)) {
            this._chartImpl = new SplinePlotImpl(this);
        } else if (FUNNEL.equals(type)) {
            this._chartImpl = new FunnelPlotImpl(this);
        } else if (AREA_RANGE.equals(type)) {
            this._chartImpl = new AreaRangePlotImpl(this);
        } else if (AREA_SPLINE_RANGE.equals(type)) {
            this._chartImpl = new AreaSplineRangePlotImpl(this);
        } else if (COLUMN_RANGE.equals(type)) {
            this._chartImpl = new ColumnRangePlotImpl(this);
        } else if (ERROR_BAR.equals(type)) {
            this._chartImpl = new ErrorBarPlotImpl(this);
        } else if (GAUGE.equals(type)) {
            this._chartImpl = new GaugePlotImpl(this);
        } else {
            throw new IllegalArgumentException("Unsupported type: [" + type + "]");
        }
        return this._chartImpl;
    }

    public boolean isRendered() {
        return this._rendered;
    }

    public void invalidate() {
        super.invalidate();
        this._rendered = false;
        if (this._drilldownLevels != null) {
            this._drilldownLevels.clear();
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        this._rendered = true;
        super.renderProperties(renderer);
        if (!this._befInvoke.isEmpty()) {
            this.render(renderer, "eval", this._befInvoke);
            this._befInvoke.clear();
        }
        if (this._plotData != null) {
            this.render(renderer, "plotData", this._plotData);
        }
        if (this._options != null) {
            this.render(renderer, "options", this._options);
        }
        if (this._theme != null) {
            this.render(renderer, "theme", this._theme);
        }
        this.render(renderer, "zclass", this._zclass);
    }

    protected void smartUpdate(String attr, Object value, boolean append) {
        super.smartUpdate(attr, value, append);
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        Map data = request.getData();
        if (cmd.equals("dummyEcho")) {
            String attrId = (String)data.get("id");
            EventListener listener = (EventListener)this.removeAttribute(attrId);
            try {
                listener.onEvent(new Event("onCallBack", (Component)this, data.get("value")));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.startsWith("onPlot")) {
            if ("onPlotDrillUp".equals(cmd)) {
                this._drilldownLevels.pop();
                final Series first = this._drilldownLevels.getFirst();
                ChartsEvent evt = new ChartsEvent(request.getCommand(), request.getComponent(), -1, -1, null, false){

                    public Series getSeries() {
                        return first;
                    }
                };
                Events.postEvent((Event)evt);
            } else if ("onPlotDrillDown".equals(cmd)) {
                int sIndex = AuRequests.getInt((Map)data, (String)"sIndex", (int)-1);
                ChartsEvent evt = null;
                if (sIndex == 0) {
                    evt = ChartsEvent.getChartsEvent(request);
                } else {
                    final Series first = this._drilldownLevels.getFirst();
                    evt = new ChartsEvent(request.getCommand(), request.getComponent(), -1, AuRequests.getInt((Map)data, (String)"pIndex", (int)-1), (Comparable)data.get("category"), false){

                        public Series getSeries() {
                            return first;
                        }
                    };
                }
                if (this._drilldownLevels == null) {
                    this._drilldownLevels = new LinkedList();
                    this._drilldownLevels.push(evt.getSeries());
                }
                int size = this._drilldownLevels.size();
                Events.postEvent((Event)evt);
                if (this._drilldownLevels.size() == size) {
                    String name = evt.getPoint().getDrilldown();
                    for (Series seri : this.getDrilldown().getSeries()) {
                        if (!name.equals(seri.getId())) continue;
                        this._drilldownLevels.addFirst(seri);
                        break;
                    }
                }
            } else if ("onPlotSelect".equals(cmd)) {
                ChartsEvent event = ChartsEvent.getChartsEvent(request);
                this.syncSelectedPoints(event.getPoint(), true);
                Events.postEvent((Event)event);
            } else if ("onPlotUnselect".equals(cmd)) {
                ChartsEvent event = ChartsEvent.getChartsEvent(request);
                this.syncSelectedPoints(event.getPoint(), false);
                Events.postEvent((Event)event);
            } else {
                Events.postEvent((Event)ChartsEvent.getChartsEvent(request));
            }
        } else if ("onClick".equals(cmd)) {
            Events.postEvent((Event)ChartsClickEvent.getChartsClickEvent(request));
        } else if ("onSelection".equals(cmd)) {
            Events.postEvent((Event)ChartsSelectionEvent.getChartsSelectionEvent(request));
        } else {
            super.service(request, everError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncSelectedPoints(Point selPoint, boolean selected) {
        this.disableClientUpdate(true);
        try {
            selPoint.setSelectedDirectly(selected);
            if (selected) {
                this._selPoints.add(selPoint);
            } else {
                this._selPoints.remove(selPoint);
            }
        }
        finally {
            this.disableClientUpdate(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectPoint(Point selPoint, boolean accumulate) {
        this.disableClientUpdate(true);
        try {
            this._selPoints.remove(selPoint);
            if (!accumulate) {
                for (Point p : this._selPoints) {
                    p.setSelectedDirectly(false);
                }
                this._selPoints.clear();
            }
            if (selPoint.isSelected()) {
                this._selPoints.add(selPoint);
            }
        }
        finally {
            this.disableClientUpdate(false);
        }
    }

    public Set<Point> getSelectedPoints() {
        return Collections.unmodifiableSet(new HashSet<Point>(this._selPoints));
    }

    public void clearPointSelection() {
        if (this._selPoints.isEmpty()) {
            return;
        }
        for (Point p : this.getSelectedPoints()) {
            p.setSelected(false);
        }
    }

    public void setZclass(String zclass) {
        if (!Objects.equals((Object)this._zclass, (Object)zclass)) {
            this._zclass = zclass;
            this.smartUpdate("zclass", zclass);
        }
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-charts";
    }

    static {
        Charts.addClientEvent(Charts.class, (String)"onClick", (int)0);
        Charts.addClientEvent(Charts.class, (String)"onDoubleClick", (int)0);
        Charts.addClientEvent(Charts.class, (String)"onRightClick", (int)0);
        Charts.addClientEvent(Charts.class, (String)"onMouseOver", (int)0);
        Charts.addClientEvent(Charts.class, (String)"onMouseOut", (int)0);
        Charts.addClientEvent(Charts.class, (String)"onSelection", (int)0);
        Charts.addClientEvent(Charts.class, (String)"onPlotClick", (int)0);
        Charts.addClientEvent(Charts.class, (String)"onPlotCheckboxClick", (int)0);
        Charts.addClientEvent(Charts.class, (String)"onPlotHide", (int)0);
        Charts.addClientEvent(Charts.class, (String)"onPlotLegendItemClick", (int)0);
        Charts.addClientEvent(Charts.class, (String)"onPlotMouseOut", (int)0);
        Charts.addClientEvent(Charts.class, (String)"onPlotMouseOver", (int)0);
        Charts.addClientEvent(Charts.class, (String)"onPlotShow", (int)0);
        Charts.addClientEvent(Charts.class, (String)"onPlotDrillDown", (int)0);
        Charts.addClientEvent(Charts.class, (String)"onPlotDrillUp", (int)0);
        Charts.addClientEvent(Charts.class, (String)"onPlotSelect", (int)1);
        Charts.addClientEvent(Charts.class, (String)"onPlotUnselect", (int)1);
        Library.setProperty((String)ZKCHARTS_LOCK, (String)"true");
        _RGEN = new Random(new Date().getTime());
        WRAP_FUNC = "function () {var self = this;this.%1$s;}";
        RETURN_FUNC = "(function () {return self.%1$s;})()";
    }

    private class MyChartsDataListener
    implements ChartsDataListener,
    Serializable {
        private static final long serialVersionUID = 20091008183622L;

        private MyChartsDataListener() {
        }

        public void onChange(ChartsDataEvent event) {
            ChartsModel model = Charts.this.getModel();
            if (model instanceof SingleValueCategoryModel || model instanceof XYModel || model instanceof CategoryModel) {
                switch (event.getType()) {
                    case 1: {
                        int sIndex = event.getSeriesIndex();
                        if (event.getCategory() instanceof Number) {
                            if (event.getData() instanceof Number[]) {
                                Number[] numbers = (Number[])event.getData();
                                if (numbers.length == 3) {
                                    Charts.this.getSeries(sIndex).addPoint(numbers[0], numbers[1], numbers[2]);
                                } else if (numbers.length == 2) {
                                    Charts.this.getSeries(sIndex).addPoint(numbers[0], numbers[1]);
                                }
                            } else {
                                Charts.this.getSeries(sIndex).addPoint((Number)((Object)event.getCategory()), (Number)event.getData());
                            }
                        } else {
                            List categories;
                            Charts.this.getSeries(sIndex).addPoint((String)((Object)event.getCategory()), (Number)event.getData());
                            if (Charts.this.getXAxis().getCategories() != null && !(categories = Charts.this.getXAxis().getCategories()).contains(event.getCategory())) {
                                ArrayList newList = new ArrayList(categories);
                                newList.add(event.getCategory());
                                Charts.this.getXAxis().setCategories(newList);
                            }
                        }
                        if (event.getSeries() != null) {
                            Charts.this.getSeries(sIndex).setName(event.getSeries().toString());
                        }
                        Charts.this.postonSyncModelLater();
                        break;
                    }
                    case 0: {
                        int cIndex = event.getCategoryIndex();
                        if (event.getData() instanceof Number[]) {
                            Number[] numbers = (Number[])event.getData();
                            Charts.this.getSeries(event.getSeriesIndex()).getPoint(cIndex).update(numbers[0], numbers[1], numbers[2]);
                        } else if (model instanceof XYModel) {
                            Charts.this.getSeries(event.getSeriesIndex()).getPoint(cIndex).update((Number)((Object)event.getCategory()), (Number)event.getData());
                        } else {
                            Charts.this.getSeries(event.getSeriesIndex()).getPoint(cIndex).update((Number)event.getData());
                        }
                        Charts.this.postonSyncModelLater();
                        break;
                    }
                    case 2: {
                        int cIndex2 = event.getCategoryIndex();
                        int sIndex2 = event.getSeriesIndex();
                        if (sIndex2 < 0) {
                            int i = Charts.this.getSeriesSize();
                            while (--i >= 0) {
                                Charts.this.getSeries(i).remove();
                            }
                            List categories = Charts.this.getXAxis().getCategories();
                            if (categories != null) {
                                Charts.this.getXAxis().setCategories(new ArrayList());
                            }
                        } else {
                            Series series2 = Charts.this.getSeries(sIndex2);
                            if (cIndex2 < 0) {
                                series2.remove();
                            } else {
                                series2.getPoint(cIndex2).remove();
                                if (series2.getData().isEmpty()) {
                                    series2.remove();
                                }
                            }
                        }
                        Charts.this.postonSyncModelLater();
                    }
                }
            } else if (model instanceof DialModel) {
                if (event instanceof DialChartsDataEvent) {
                    DialChartsDataEventImpl evt = (DialChartsDataEventImpl)event;
                    String key = evt.getPropertyKey();
                    if ("scaleValue".equals(key)) {
                        Charts.this.getSeries().getPoint(0).update((Number)evt.getData());
                    } else if ("scaleText".equals(key)) {
                        Charts.this.getYAxis().getTitle().setText((String)evt.getData());
                    } else if ("needleColor".equals(key)) {
                        Charts.this.getPlotOptions().getGauge().getDial().setBackgroundColor((String)evt.getData());
                    } else {
                        Charts.this.smartDrawChart();
                        Charts.this.invalidate();
                    }
                }
            } else {
                throw new UiException("Unsupported with the model type [" + model + "]");
            }
        }
    }
}

