/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.chart.Animation;
import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.ResetZoomButton;
import org.zkoss.chart.Shadow;
import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.MapsHelper;
import org.zkoss.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chart
extends Optionable {
    public boolean isAlignTicks() {
        return this.getAttr(Attrs.alignTicks, true).asBoolean();
    }

    public void setAlignTicks(boolean alignTicks) {
        this.setAttr(Attrs.alignTicks, alignTicks);
    }

    public Animation getAnimation() {
        if (this.containsKey(Attrs.animation)) {
            return (Animation)this.getAttr(Attrs.animation);
        }
        return (Animation)this.getAttr(Attrs.animation, Animation.class).asValue();
    }

    public boolean isAnimation() {
        return this.getAnimation() != Animation.NONE;
    }

    public void setAnimation(boolean animation) {
        this.setAnimation(animation ? new Animation() : Animation.NONE);
    }

    public void setAnimation(Animation animation) {
        this.setAttr(Attrs.animation, animation == null ? Animation.NONE : animation);
    }

    public Color getBackgroundColor() {
        if (!this.containsKey(Attrs.backgroundColor)) {
            this.setBackgroundColor("#A0A0A0");
        }
        return (Color)this.getAttr(Attrs.backgroundColor);
    }

    public void setBackgroundColor(Color color) {
        this.setAttr((PlotAttribute)Attrs.backgroundColor, color, NOT_NULL_VALUE);
    }

    public void setBackgroundColor(String color) {
        this.setBackgroundColor(new Color(color));
    }

    public void setBackgroundColor(LinearGradient color) {
        this.setBackgroundColor(new Color(color));
    }

    public void setBackgroundColor(RadialGradient color) {
        this.setBackgroundColor(new Color(color));
    }

    public Color getBorderColor() {
        if (!this.containsKey(Attrs.borderColor)) {
            this.setBorderColor("#4572A7");
        }
        return (Color)this.getAttr(Attrs.borderColor);
    }

    public void setBorderColor(Color color) {
        this.setAttr((PlotAttribute)Attrs.borderColor, color, NOT_NULL_VALUE);
    }

    public void setBorderColor(String color) {
        this.setBorderColor(new Color(color));
    }

    public void setBorderColor(LinearGradient color) {
        this.setBorderColor(new Color(color));
    }

    public void setBorderColor(RadialGradient color) {
        this.setBorderColor(new Color(color));
    }

    public Number getBorderRadius() {
        return this.getAttr(Attrs.borderRadius, 5).asNumber();
    }

    public void setBorderRadius(Number borderRadius) {
        this.setAttr((PlotAttribute)Attrs.borderRadius, borderRadius, Integer.valueOf(5));
    }

    public Number getBorderWidth() {
        return this.getAttr(Attrs.borderWidth, 0).asNumber();
    }

    public void setBorderWidth(Number borderWidth) {
        this.setAttr((PlotAttribute)Attrs.borderWidth, borderWidth, Integer.valueOf(0));
    }

    public Number getHeight() {
        return this.getAttr(Attrs.height, null).asNumber();
    }

    public void setHeight(Number height) {
        this.setAttr(Attrs.height, height);
    }

    public boolean isIgnoreHiddenSeries() {
        return this.getAttr(Attrs.ignoreHiddenSeries, true).asBoolean();
    }

    public void setIgnoreHiddenSeries(boolean ignoreHiddenSeries) {
        this.setAttr(Attrs.ignoreHiddenSeries, ignoreHiddenSeries);
    }

    public boolean isInverted() {
        return this.getAttr(Attrs.inverted, false).asBoolean();
    }

    public void setInverted(boolean inverted) {
        this.setAttr(Attrs.inverted, inverted);
    }

    public Number[] getMargin() {
        return this.getAttr(Attrs.margin, null).asNumberArray();
    }

    public void setMargin(Number[] margin) {
        this.setAttr(Attrs.margin, margin);
    }

    public Number getMarginBottom() {
        return this.getAttr(Attrs.marginBottom, null).asNumber();
    }

    public void setMarginBottom(Number marginBottom) {
        this.setAttr(Attrs.marginBottom, marginBottom);
    }

    public Number getMarginLeft() {
        return this.getAttr(Attrs.marginLeft, null).asNumber();
    }

    public void setMarginLeft(Number marginLeft) {
        this.setAttr(Attrs.marginLeft, marginLeft);
    }

    public Number getMarginRight() {
        return this.getAttr(Attrs.marginRight, null).asNumber();
    }

    public void setMarginRight(Number marginRight) {
        this.setAttr(Attrs.marginRight, marginRight);
    }

    public Number getMarginTop() {
        return this.getAttr(Attrs.marginTop, null).asNumber();
    }

    public void setMarginTop(Number marginTop) {
        this.setAttr(Attrs.marginTop, marginTop);
    }

    public String getPinchType() {
        return this.getAttr(Attrs.pinchType, null).asString();
    }

    public void setPinchType(String pinchType) {
        this.setAttr(Attrs.pinchType, pinchType);
    }

    public Color getPlotBackgroundColor() {
        return (Color)this.getAttr(Attrs.plotBackgroundColor, null).asValue();
    }

    public void setPlotBackgroundColor(Color color) {
        this.setAttr(Attrs.plotBackgroundColor, color);
    }

    public void setPlotBackgroundColor(String color) {
        this.setPlotBackgroundColor(new Color(color));
    }

    public void setPlotBackgroundColor(LinearGradient color) {
        this.setPlotBackgroundColor(new Color(color));
    }

    public void setPlotBackgroundColor(RadialGradient color) {
        this.setPlotBackgroundColor(new Color(color));
    }

    public String getPlotBackgroundImage() {
        return this.getAttr(Attrs.plotBackgroundImage, null).asString();
    }

    public void setPlotBackgroundImage(String plotBackgroundImage) {
        this.setAttr(Attrs.plotBackgroundImage, plotBackgroundImage);
    }

    public Color getPlotBorderColor() {
        if (!this.containsKey(Attrs.plotBorderColor)) {
            this.setPlotBorderColor("#C0C0C0");
        }
        return (Color)this.getAttr(Attrs.plotBorderColor);
    }

    public void setPlotBorderColor(Color color) {
        this.setAttr((PlotAttribute)Attrs.plotBorderColor, color, NOT_NULL_VALUE);
    }

    public void setPlotBorderColor(String color) {
        this.setPlotBorderColor(new Color(color));
    }

    public void setPlotBorderColor(LinearGradient color) {
        this.setPlotBorderColor(new Color(color));
    }

    public void setPlotBorderColor(RadialGradient color) {
        this.setPlotBorderColor(new Color(color));
    }

    public Number getPlotBorderWidth() {
        return this.getAttr(Attrs.plotBorderWidth, 0).asNumber();
    }

    public void setPlotBorderWidth(Number plotBorderWidth) {
        this.setAttr((PlotAttribute)Attrs.plotBorderWidth, plotBorderWidth, Integer.valueOf(0));
    }

    public boolean isPlotShadow() {
        return this.getAttr(Attrs.plotShadow, false).asBoolean();
    }

    public void setPlotShadow(boolean plotShadow) {
        this.setAttr(Attrs.plotShadow, plotShadow);
    }

    public boolean isPolar() {
        return this.getAttr(Attrs.polar, false).asBoolean();
    }

    public void setPolar(boolean polar) {
        this.setAttr(Attrs.polar, polar);
    }

    public boolean isReflow() {
        return this.getAttr(Attrs.reflow, true).asBoolean();
    }

    public void setReflow(boolean reflow) {
        this.setAttr(Attrs.reflow, reflow);
    }

    public ResetZoomButton getResetZoomButton() {
        return (ResetZoomButton)this.getAttr(Attrs.resetZoomButton, null).asValue();
    }

    public void setResetZoomButton(ResetZoomButton resetZoomButton) {
        this.setAttr(Attrs.resetZoomButton, resetZoomButton);
    }

    public Color getSelectionMarkerFill() {
        if (!this.containsKey(Attrs.selectionMarkerFill)) {
            this.setSelectionMarkerFill("rgba(69,114,167,0.25)");
        }
        return (Color)this.getAttr(Attrs.selectionMarkerFill);
    }

    public void setSelectionMarkerFill(Color color) {
        this.setAttr((PlotAttribute)Attrs.selectionMarkerFill, color, NOT_NULL_VALUE);
    }

    public void setSelectionMarkerFill(String color) {
        this.setSelectionMarkerFill(new Color(color));
    }

    public void setSelectionMarkerFill(LinearGradient color) {
        this.setSelectionMarkerFill(new Color(color));
    }

    public void setSelectionMarkerFill(RadialGradient color) {
        this.setSelectionMarkerFill(new Color(color));
    }

    public boolean isShadow() {
        return this.getShadow() != Shadow.NONE;
    }

    public Shadow getShadow() {
        return (Shadow)this.getAttr(Attrs.shadow, Shadow.NONE).asValue();
    }

    public void setShadow(boolean shadow) {
        this.setShadow(shadow ? new Shadow() : Shadow.NONE);
    }

    public void setShadow(Shadow shadow) {
        this.setAttr(Attrs.shadow, shadow);
    }

    public boolean isShowAxes() {
        return this.getAttr(Attrs.showAxes, false).asBoolean();
    }

    public void setShowAxes(boolean showAxes) {
        this.setAttr(Attrs.showAxes, showAxes);
    }

    public Number[] getSpacing() {
        return this.getAttr(Attrs.spacing, new Number[]{10, 10, 15, 10}).asNumberArray();
    }

    public void setSpacing(Number[] spacing) {
        this.setAttr((PlotAttribute)Attrs.spacing, spacing, NOT_NULL_VALUE);
    }

    public Number getSpacingBottom() {
        return this.getAttr(Attrs.spacingBottom, 15).asNumber();
    }

    public void setSpacingBottom(Number spacingBottom) {
        this.setAttr((PlotAttribute)Attrs.spacingBottom, spacingBottom, Integer.valueOf(15));
    }

    public Number getSpacingLeft() {
        return this.getAttr(Attrs.spacingLeft, 10).asNumber();
    }

    public void setSpacingLeft(Number spacingLeft) {
        this.setAttr((PlotAttribute)Attrs.spacingLeft, spacingLeft, Integer.valueOf(10));
    }

    public Number getSpacingRight() {
        return this.getAttr(Attrs.spacingRight, 10).asNumber();
    }

    public void setSpacingRight(Number spacingRight) {
        this.setAttr((PlotAttribute)Attrs.spacingRight, spacingRight, Integer.valueOf(10));
    }

    public Number getSpacingTop() {
        return this.getAttr(Attrs.spacingTop, 10).asNumber();
    }

    public void setSpacingTop(Number spacingTop) {
        this.setAttr((PlotAttribute)Attrs.spacingTop, spacingTop, Integer.valueOf(10));
    }

    public <K, V> Map<K, V> getStyle() {
        if (!this.containsKey(Attrs.style)) {
            this.setStyle("fontFamily: \"Lucida Grande\", \"Lucida Sans Unicode\", Verdana, Arial, Helvetica, sans-serif; fontSize: 12px");
        }
        return (Map)Generics.cast((Object)this.getAttr(Attrs.style));
    }

    public void setStyle(String style) {
        this.setStyle(MapsHelper.parse(new LinkedHashMap(), style, ':', ';', '\''));
    }

    public <K, V> void setStyle(Map<K, V> style) {
        this.setAttr((PlotAttribute)Attrs.style, style, NOT_NULL_VALUE);
    }

    public String getType() {
        return this.getAttr(Attrs.type, "line").asString();
    }

    public void setType(String type) {
        this.setAttr((PlotAttribute)Attrs.type, type, "line");
    }

    public Number getWidth() {
        return this.getAttr(Attrs.width, null).asNumber();
    }

    public void setWidth(Number width) {
        this.setAttr(Attrs.width, width);
    }

    public String getZoomType() {
        return this.getAttr(Attrs.zoomType, null).asString();
    }

    public void setZoomType(String zoomType) {
        if (!(zoomType == null || "x".equals(zoomType) || "y".equals(zoomType) || "xy".equals(zoomType))) {
            throw new IllegalArgumentException("Unsupported zoomType: [" + zoomType + "]");
        }
        this.setAttr(Attrs.zoomType, zoomType);
    }

    public Boolean isEnableZoomSelection() {
        return this.getAttr(Attrs.enableZoomSelection, true).asBoolean();
    }

    public void setEnableZoomSelection(boolean enableZoomSelection) {
        this.setAttr(Attrs.enableZoomSelection, enableZoomSelection);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        alignTicks,
        animation,
        backgroundColor,
        borderColor,
        borderRadius,
        borderWidth,
        height,
        ignoreHiddenSeries,
        inverted,
        margin,
        marginBottom,
        marginLeft,
        marginRight,
        marginTop,
        pinchType,
        plotBackgroundColor,
        plotBackgroundImage,
        plotBorderColor,
        plotBorderWidth,
        plotShadow,
        polar,
        reflow,
        resetZoomButton,
        selectionMarkerFill,
        shadow,
        showAxes,
        spacing,
        spacingBottom,
        spacingLeft,
        spacingRight,
        spacingTop,
        style,
        type,
        width,
        zoomType,
        enableZoomSelection;

    }
}

