/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.MapsHelper;
import org.zkoss.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisTitle
extends Optionable {
    public String getAlign() {
        return this.getAttr(Attrs.align, "middle").asString();
    }

    public void setAlign(String align) {
        if (!("low".equals(align) || "middle".equals(align) || "high".equals(align))) {
            throw new IllegalArgumentException("Unsupported align: [" + align + "]");
        }
        this.setAttr((PlotAttribute)Attrs.align, align, "middle");
    }

    public Number getMargin() {
        return this.getAttr(Attrs.margin, 0).asNumber();
    }

    public void setMargin(Number margin) {
        this.setAttr((PlotAttribute)Attrs.margin, margin, Integer.valueOf(0));
    }

    public Number getOffset() {
        return this.getAttr(Attrs.offset, null).asNumber();
    }

    public void setOffset(Number offset) {
        this.setAttr(Attrs.offset, offset);
    }

    public Number getRotation() {
        return this.getAttr(Attrs.rotation, 0).asNumber();
    }

    public void setRotation(Number rotation) {
        this.setAttr((PlotAttribute)Attrs.rotation, rotation, Integer.valueOf(0));
    }

    public <K, V> Map<K, V> getStyle() {
        if (!this.containsKey(Attrs.style)) {
            this.setStyle("color: #6D869F; fontWeight: bold;");
        }
        return (Map)Generics.cast((Object)this.getAttr(Attrs.style));
    }

    public void setStyle(String style) {
        this.setStyle(MapsHelper.parse(new LinkedHashMap(), style, ':', ';', '\''));
    }

    public <K, V> void setStyle(Map<K, V> style) {
        this.setAttr((PlotAttribute)Attrs.style, style, NOT_NULL_VALUE);
    }

    public String getText() {
        return this.getAttr(Attrs.text, null).asString();
    }

    public void setText(String text) {
        this.setAttr(Attrs.text, text);
    }

    public Number getX() {
        return this.getAttr(Attrs.x, 0).asNumber();
    }

    public void setX(Number x) {
        this.setAttr((PlotAttribute)Attrs.x, x, Integer.valueOf(0));
    }

    public Number getY() {
        return this.getAttr(Attrs.y, 0).asNumber();
    }

    public void setY(Number y) {
        this.setAttr((PlotAttribute)Attrs.y, y, Integer.valueOf(0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        align,
        margin,
        offset,
        rotation,
        style,
        text,
        x,
        y;

    }
}

