/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.MapsHelper;
import org.zkoss.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisLabels
extends Optionable {
    public String getAlign() {
        return this.getAttr(Attrs.align, "center").asString();
    }

    public void setAlign(String align) {
        if (!("center".equals(align) || "left".equals(align) || "right".equals(align))) {
            throw new IllegalArgumentException("Unsupported align [" + align + "]");
        }
        this.setAttr((PlotAttribute)Attrs.align, align, "center");
    }

    public Number getDistance() {
        return this.getAttr(Attrs.distance, 15).asNumber();
    }

    public void setDistance(Number distance) {
        this.setAttr((PlotAttribute)Attrs.distance, distance, Integer.valueOf(15));
    }

    public boolean isEnabled() {
        return this.getAttr(Attrs.enabled, true).asBoolean();
    }

    public void setEnabled(boolean enabled) {
        this.setAttr(Attrs.enabled, enabled);
    }

    public String getFormat() {
        return this.getAttr(Attrs.format, "{value}").asString();
    }

    public void setFormat(String format) {
        this.setAttr((PlotAttribute)Attrs.format, format, "{value}");
    }

    public Number getMaxStaggerLines() {
        return this.getAttr(Attrs.maxStaggerLines, 5).asNumber();
    }

    public void setMaxStaggerLines(Number maxStaggerLines) {
        this.setAttr((PlotAttribute)Attrs.maxStaggerLines, maxStaggerLines, Integer.valueOf(5));
    }

    public String getOverflow() {
        return this.getAttr(Attrs.overflow, null).asString();
    }

    public void setOverflow(String overflow) {
        this.setAttr(Attrs.overflow, overflow);
    }

    public Object getRotation() {
        return this.getAttr(Attrs.rotation, 0).asValue();
    }

    public void setRotation(Number rotation) {
        this.setAttr((PlotAttribute)Attrs.rotation, rotation, Integer.valueOf(0));
    }

    public void setRotation(String rotation) {
        this.setAttr(Attrs.rotation, rotation);
    }

    public Number getStaggerLines() {
        return this.getAttr(Attrs.staggerLines, 0).asNumber();
    }

    public void setStaggerLines(Number staggerLines) {
        this.setAttr((PlotAttribute)Attrs.staggerLines, staggerLines, Integer.valueOf(0));
    }

    public Number getStep() {
        return this.getAttr(Attrs.step, null).asNumber();
    }

    public void setStep(Number step) {
        this.setAttr(Attrs.step, step);
    }

    public <K, V> Map<K, V> getStyle() {
        if (!this.containsKey(Attrs.style)) {
            this.setStyle("color: #6D869F; fontWeight: bold;");
        }
        return (Map)Generics.cast((Object)this.getAttr(Attrs.style));
    }

    public void setStyle(String style) {
        this.setStyle(MapsHelper.parse(new LinkedHashMap(), style, ':', ';', '\''));
    }

    public <K, V> void setStyle(Map<K, V> style) {
        this.setAttr((PlotAttribute)Attrs.style, style, NOT_NULL_VALUE);
    }

    public boolean isUseHTML() {
        return this.getAttr(Attrs.useHTML, false).asBoolean();
    }

    public void setUseHTML(boolean useHTML) {
        this.setAttr(Attrs.useHTML, useHTML);
    }

    public Number getX() {
        return this.getAttr(Attrs.x, 0).asNumber();
    }

    public void setX(Number x) {
        this.setAttr((PlotAttribute)Attrs.x, x, Integer.valueOf(0));
    }

    public Number getY() {
        return this.getAttr(Attrs.y, 0).asNumber();
    }

    public void setY(Number y) {
        this.setAttr((PlotAttribute)Attrs.y, y, NOT_NULL_VALUE);
    }

    public Number getZIndex() {
        return this.getAttr(Attrs.zIndex, 7).asNumber();
    }

    public void setZIndex(Number zIndex) {
        this.setAttr((PlotAttribute)Attrs.zIndex, zIndex, Integer.valueOf(7));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute,
    DynamicalAttribute
    {
        align,
        distance,
        enabled,
        format,
        formatter,
        maxStaggerLines,
        overflow,
        rotation,
        staggerLines,
        step,
        style,
        useHTML,
        x,
        y,
        zIndex;

    }
}

