/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.chart;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.zkoss.chart.Animation;
import org.zkoss.chart.AxisLabels;
import org.zkoss.chart.AxisTitle;
import org.zkoss.chart.Color;
import org.zkoss.chart.DateTimeLabelFormats;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.OptionDataEvent;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.PlotBand;
import org.zkoss.chart.PlotLine;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.util.DeferredCall;
import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.JSFunction;
import org.zkoss.json.JSONObject;
import org.zkoss.lang.Generics;
import org.zkoss.lang.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis
extends Optionable {
    public void setExtremes(final Number min, final Number max, final boolean redraw, final Animation animation) {
        this.fireEvent(OptionDataEvent.EventType.INVOKE, "extremes", null, new DeferredCall(){

            public void execute(JSFunction func) {
                func.callFunction("setExtremes", min, max, redraw, animation);
            }
        });
    }

    public void setExtremes(Number min, Number max) {
        this.setExtremes(min, max, true, new Animation());
    }

    public boolean isAllowDecimals() {
        return this.getAttr(DAttrs.allowDecimals, true).asBoolean();
    }

    public void setAllowDecimals(boolean allowDecimals) {
        this.setAttr(DAttrs.allowDecimals, allowDecimals);
    }

    public Color getAlternateGridColor() {
        return (Color)this.getAttr(DAttrs.alternateGridColor, null).asValue();
    }

    public void setAlternateGridColor(Color color) {
        this.setAttr(DAttrs.alternateGridColor, color);
    }

    public void setAlternateGridColor(String color) {
        this.setAlternateGridColor(new Color(color));
    }

    public void setAlternateGridColor(LinearGradient color) {
        this.setAlternateGridColor(new Color(color));
    }

    public void setAlternateGridColor(RadialGradient color) {
        this.setAlternateGridColor(new Color(color));
    }

    public <T> List<T> getCategories() {
        return (List)Generics.cast((Object)this.getAttr(DAttrs.categories, null).asValue());
    }

    public <T> void setCategories(List<T> categories) {
        this.setAttr(DAttrs.categories, categories);
    }

    public void setCategories(String ... categories) {
        this.setAttr(DAttrs.categories, categories);
    }

    public DateTimeLabelFormats getDateTimeLabelFormats() {
        DateTimeLabelFormats dateTimeLabelFormats = (DateTimeLabelFormats)this.getAttr(DAttrs.dateTimeLabelFormats);
        if (dateTimeLabelFormats == null) {
            dateTimeLabelFormats = new DateTimeLabelFormats();
            this.setDateTimeLabelFormats(dateTimeLabelFormats);
        }
        return dateTimeLabelFormats;
    }

    public void setDateTimeLabelFormats(DateTimeLabelFormats dateTimeLabelFormats) {
        this.setAttr(DAttrs.dateTimeLabelFormats, dateTimeLabelFormats);
    }

    public boolean isEndOnTick() {
        return this.getAttr(DAttrs.endOnTick, false).asBoolean();
    }

    public void setEndOnTick(boolean endOnTick) {
        this.setAttr(DAttrs.endOnTick, endOnTick);
    }

    public Color getGridLineColor() {
        if (!this.containsKey(DAttrs.gridLineColor)) {
            this.setGridLineColor("#C0C0C0");
        }
        return (Color)this.getAttr(DAttrs.gridLineColor);
    }

    public void setGridLineColor(Color color) {
        this.setAttr((PlotAttribute)DAttrs.gridLineColor, color, NOT_NULL_VALUE);
    }

    public void setGridLineColor(String color) {
        this.setGridLineColor(new Color(color));
    }

    public void setGridLineColor(LinearGradient color) {
        this.setGridLineColor(new Color(color));
    }

    public void setGridLineColor(RadialGradient color) {
        this.setGridLineColor(new Color(color));
    }

    public String getGridLineDashStyle() {
        return this.getAttr(DAttrs.gridLineDashStyle, "Solid").asString();
    }

    public void setGridLineDashStyle(String gridLineDashStyle) {
        if (!("Solid".equalsIgnoreCase(gridLineDashStyle) || "ShortDash".equalsIgnoreCase(gridLineDashStyle) || "ShortDot".equalsIgnoreCase(gridLineDashStyle) || "ShortDashDot".equalsIgnoreCase(gridLineDashStyle) || "ShortDashDotDot".equalsIgnoreCase(gridLineDashStyle) || "Dot".equalsIgnoreCase(gridLineDashStyle) || "Dash".equalsIgnoreCase(gridLineDashStyle) || "LongDash".equalsIgnoreCase(gridLineDashStyle) || "DashDot".equalsIgnoreCase(gridLineDashStyle) || "LongDashDot".equalsIgnoreCase(gridLineDashStyle) || "LongDashDotDot".equalsIgnoreCase(gridLineDashStyle))) {
            throw new IllegalArgumentException("Unsupported style: [" + gridLineDashStyle + "]");
        }
        this.setAttr((PlotAttribute)DAttrs.gridLineDashStyle, gridLineDashStyle, "Solid");
    }

    public String getGridLineInterpolation() {
        return this.getAttr(DAttrs.gridLineInterpolation, null).asString();
    }

    public void setGridLineInterpolation(String gridLineInterpolation) {
        this.setAttr(DAttrs.gridLineInterpolation, gridLineInterpolation);
    }

    public Number getGridLineWidth() {
        return this.getAttr(DAttrs.gridLineWidth, 0).asNumber();
    }

    public void setGridLineWidth(Number gridLineWidth) {
        this.setAttr((PlotAttribute)DAttrs.gridLineWidth, gridLineWidth, Integer.valueOf(0));
    }

    public String getId() {
        return this.getAttr(DAttrs.id, null).asString();
    }

    public void setId(String id) {
        this.setAttr(DAttrs.id, id);
    }

    public AxisLabels getLabels() {
        AxisLabels labels = (AxisLabels)this.getAttr(DAttrs.labels);
        if (labels == null) {
            labels = new AxisLabels();
            this.setLabels(labels);
        }
        return labels;
    }

    public void setLabels(AxisLabels labels) {
        this.setAttr(DAttrs.labels, labels);
    }

    public Color getLineColor() {
        if (!this.containsKey(DAttrs.lineColor)) {
            this.setLineColor("#C0D0E0");
        }
        return (Color)this.getAttr(DAttrs.lineColor);
    }

    public void setLineColor(Color color) {
        this.setAttr((PlotAttribute)DAttrs.lineColor, color, NOT_NULL_VALUE);
    }

    public void setLineColor(String color) {
        this.setLineColor(new Color(color));
    }

    public void setLineColor(LinearGradient color) {
        this.setLineColor(new Color(color));
    }

    public void setLineColor(RadialGradient color) {
        this.setLineColor(new Color(color));
    }

    public Number getLineWidth() {
        return this.getAttr(DAttrs.lineWidth, 1).asNumber();
    }

    public void setLineWidth(Number lineWidth) {
        this.setAttr((PlotAttribute)DAttrs.lineWidth, lineWidth, Integer.valueOf(1));
    }

    public Number getLinkedTo() {
        return this.getAttr(DAttrs.linkedTo, null).asNumber();
    }

    public void setLinkedTo(Number linkedTo) {
        this.setAttr(DAttrs.linkedTo, linkedTo);
    }

    public Number getMax() {
        return this.getAttr(DAttrs.max, null).asNumber();
    }

    public void setMax(Number max) {
        this.setAttr(DAttrs.max, max);
    }

    public Number getMaxPadding() {
        return this.getAttr(DAttrs.maxPadding, 0.01).asNumber();
    }

    public void setMaxPadding(Number maxPadding) {
        this.setAttr((PlotAttribute)DAttrs.maxPadding, maxPadding, Double.valueOf(0.01));
    }

    public Number getMin() {
        return this.getAttr(DAttrs.min, null).asNumber();
    }

    public void setMin(Number min) {
        this.setAttr(DAttrs.min, min);
    }

    public Number getMinPadding() {
        return this.getAttr(DAttrs.minPadding, 0.01).asNumber();
    }

    public void setMinPadding(Number minPadding) {
        this.setAttr((PlotAttribute)DAttrs.minPadding, minPadding, Double.valueOf(0.01));
    }

    public Number getMinRange() {
        return this.getAttr(DAttrs.minRange, null).asNumber();
    }

    public void setMinRange(Number minRange) {
        this.setAttr(DAttrs.minRange, minRange);
    }

    public Number getMinTickInterval() {
        return this.getAttr(DAttrs.minTickInterval, null).asNumber();
    }

    public void setMinTickInterval(Number minTickInterval) {
        this.setAttr(DAttrs.minTickInterval, minTickInterval);
    }

    public Color getMinorGridLineColor() {
        if (!this.containsKey(DAttrs.minorGridLineColor)) {
            this.setMinorGridLineColor("#E0E0E0");
        }
        return (Color)this.getAttr(DAttrs.minorGridLineColor);
    }

    public void setMinorGridLineColor(Color color) {
        this.setAttr((PlotAttribute)DAttrs.minorGridLineColor, color, NOT_NULL_VALUE);
    }

    public void setMinorGridLineColor(String color) {
        this.setMinorGridLineColor(new Color(color));
    }

    public void setMinorGridLineColor(LinearGradient color) {
        this.setMinorGridLineColor(new Color(color));
    }

    public void setMinorGridLineColor(RadialGradient color) {
        this.setMinorGridLineColor(new Color(color));
    }

    public String getMinorGridLineDashStyle() {
        return this.getAttr(DAttrs.minorGridLineDashStyle, "Solid").asString();
    }

    public void setMinorGridLineDashStyle(String minorGridLineDashStyle) {
        if (!("Solid".equalsIgnoreCase(minorGridLineDashStyle) || "ShortDash".equalsIgnoreCase(minorGridLineDashStyle) || "ShortDot".equalsIgnoreCase(minorGridLineDashStyle) || "ShortDashDot".equalsIgnoreCase(minorGridLineDashStyle) || "ShortDashDotDot".equalsIgnoreCase(minorGridLineDashStyle) || "Dot".equalsIgnoreCase(minorGridLineDashStyle) || "Dash".equalsIgnoreCase(minorGridLineDashStyle) || "LongDash".equalsIgnoreCase(minorGridLineDashStyle) || "DashDot".equalsIgnoreCase(minorGridLineDashStyle) || "LongDashDot".equalsIgnoreCase(minorGridLineDashStyle) || "LongDashDotDot".equalsIgnoreCase(minorGridLineDashStyle))) {
            throw new IllegalArgumentException("Unsupported style: [" + minorGridLineDashStyle + "]");
        }
        this.setAttr((PlotAttribute)DAttrs.minorGridLineDashStyle, minorGridLineDashStyle, "Solid");
    }

    public Number getMinorGridLineWidth() {
        return this.getAttr(DAttrs.minorGridLineWidth, 1).asNumber();
    }

    public void setMinorGridLineWidth(Number minorGridLineWidth) {
        this.setAttr((PlotAttribute)DAttrs.minorGridLineWidth, minorGridLineWidth, Integer.valueOf(1));
    }

    public Color getMinorTickColor() {
        if (!this.containsKey(DAttrs.minorTickColor)) {
            this.setMinorTickColor("#A0A0A0");
        }
        return (Color)this.getAttr(DAttrs.minorTickColor);
    }

    public void setMinorTickColor(Color color) {
        this.setAttr((PlotAttribute)DAttrs.minorTickColor, color, NOT_NULL_VALUE);
    }

    public void setMinorTickColor(String color) {
        this.setMinorTickColor(new Color(color));
    }

    public void setMinorTickColor(LinearGradient color) {
        this.setMinorTickColor(new Color(color));
    }

    public void setMinorTickColor(RadialGradient color) {
        this.setMinorTickColor(new Color(color));
    }

    public Number getMinorTickInterval() {
        return this.getAttr(DAttrs.minorTickInterval, null).asNumber();
    }

    public void setMinorTickInterval(Number minorTickInterval) {
        this.setAttr(DAttrs.minorTickInterval, minorTickInterval);
    }

    public void setMinorTickInterval(String minorTickInterval) {
        this.setAttr(DAttrs.minorTickInterval, minorTickInterval);
    }

    public Number getMinorTickLength() {
        return this.getAttr(DAttrs.minorTickLength, 2).asNumber();
    }

    public void setMinorTickLength(Number minorTickLength) {
        this.setAttr((PlotAttribute)DAttrs.minorTickLength, minorTickLength, Integer.valueOf(2));
    }

    public String getMinorTickPosition() {
        return this.getAttr(DAttrs.minorTickPosition, "outside").asString();
    }

    public void setMinorTickPosition(String minorTickPosition) {
        if (!"inside".equals(minorTickPosition) && !"outside".equals(minorTickPosition)) {
            throw new IllegalArgumentException("Unsupported position: [" + minorTickPosition + "]");
        }
        this.setAttr((PlotAttribute)DAttrs.minorTickPosition, minorTickPosition, NOT_NULL_VALUE);
    }

    public Number getMinorTickWidth() {
        return this.getAttr(DAttrs.minorTickWidth, 0).asNumber();
    }

    public void setMinorTickWidth(Number minorTickWidth) {
        this.setAttr((PlotAttribute)DAttrs.minorTickWidth, minorTickWidth, Integer.valueOf(0));
    }

    public Number getOffset() {
        return this.getAttr(DAttrs.offset, 0).asNumber();
    }

    public void setOffset(Number offset) {
        this.setAttr((PlotAttribute)DAttrs.offset, offset, Integer.valueOf(0));
    }

    public boolean isOpposite() {
        return this.getAttr(DAttrs.opposite, false).asBoolean();
    }

    public void setOpposite(boolean opposite) {
        this.setAttr(DAttrs.opposite, opposite);
    }

    public Number getPane() {
        return this.getAttr(DAttrs.pane, 0).asNumber();
    }

    public void setPane(Number pane) {
        this.setAttr((PlotAttribute)DAttrs.pane, pane, Integer.valueOf(0));
    }

    public List<PlotBand> getPlotBands() {
        return (List)Generics.cast((Object)this.getAttr(Attrs.plotBands, null).asValue());
    }

    public void setPlotBands(List<PlotBand> plotBands) {
        List<PlotBand> oldPlotBands = this.getPlotBands();
        if (oldPlotBands != null) {
            CopyOnWriteArrayList<PlotBand> copy = new CopyOnWriteArrayList<PlotBand>(oldPlotBands);
            for (PlotBand plotBand : copy) {
                this.removePlotBand(plotBand);
            }
        }
        for (PlotBand plotBand : plotBands) {
            this.addPlotBand(plotBand);
        }
    }

    public void addPlotBand(final PlotBand plotBand) {
        List<PlotBand> plotBands = this.getPlotBands();
        if (plotBands == null) {
            plotBands = new LinkedList<PlotBand>();
        }
        plotBand.addOptionDataListener(this);
        plotBands.add(plotBand);
        this.setAttr(Attrs.plotBands, plotBands);
        this.fireEvent(OptionDataEvent.EventType.ADDED, Attrs.plotband.toString(), (Object)plotBand, new DeferredCall(){

            public void execute(JSFunction func) {
                func.callFunction("addPlotBand", plotBand);
            }
        });
    }

    public void removePlotBand(String id) {
        List<PlotBand> plotBands = this.getPlotBands();
        if (plotBands == null) {
            return;
        }
        for (PlotBand plotBand : plotBands) {
            if (!Objects.equals((Object)plotBand.getId(), (Object)id)) continue;
            this.removePlotBand(plotBand);
            return;
        }
    }

    public void removePlotBand(final PlotBand plotBand) {
        List<PlotBand> plotBands = this.getPlotBands();
        if (plotBands == null) {
            return;
        }
        if (plotBand != null) {
            plotBands.remove(plotBand);
            plotBand.removeOptionDataListener(this);
            this.fireEvent(OptionDataEvent.EventType.REMOVED, Attrs.plotband.toString(), (Object)plotBand, new DeferredCall(){

                public void execute(JSFunction func) {
                    func.callFunction("removePlotBand", plotBand.getId());
                }
            });
        }
    }

    public List<PlotLine> getPlotLines() {
        return (List)Generics.cast((Object)this.getAttr(Attrs.plotLines, null).asValue());
    }

    public void setPlotLines(List<PlotLine> plotLines) {
        List<PlotLine> oldPlotLines = this.getPlotLines();
        if (oldPlotLines != null) {
            CopyOnWriteArrayList<PlotLine> copy = new CopyOnWriteArrayList<PlotLine>(oldPlotLines);
            for (PlotLine plotLine : copy) {
                this.removePlotLine(plotLine);
            }
        }
        for (PlotLine plotLine : plotLines) {
            this.addPlotLine(plotLine);
        }
    }

    public void addPlotLine(final PlotLine plotLine) {
        List<PlotLine> plotLines = this.getPlotLines();
        if (plotLines == null) {
            plotLines = new LinkedList<PlotLine>();
        }
        plotLine.addOptionDataListener(this);
        plotLines.add(plotLine);
        this.setAttr(Attrs.plotLines, plotLines);
        this.fireEvent(OptionDataEvent.EventType.ADDED, Attrs.plotLine.toString(), (Object)plotLine, new DeferredCall(){

            public void execute(JSFunction func) {
                func.callFunction("addPlotLine", plotLine);
            }
        });
    }

    public void removePlotLine(final String id) {
        List<PlotLine> plotLines = this.getPlotLines();
        if (plotLines == null) {
            return;
        }
        Optionable target = null;
        for (PlotLine plotLine : plotLines) {
            if (!Objects.equals((Object)plotLine.getId(), (Object)id)) continue;
            target = plotLine;
            break;
        }
        if (target != null) {
            target.removeOptionDataListener(this);
            plotLines.remove(target);
            this.fireEvent(OptionDataEvent.EventType.REMOVED, Attrs.plotLine.toString(), (Object)target, new DeferredCall(){

                public void execute(JSFunction func) {
                    func.callFunction("removePlotLine", id);
                }
            });
        }
    }

    public void removePlotLine(final PlotLine plotLine) {
        List<PlotLine> plotLines = this.getPlotLines();
        if (plotLines == null) {
            return;
        }
        if (plotLine != null) {
            plotLines.remove(plotLine);
            plotLine.removeOptionDataListener(this);
            this.fireEvent(OptionDataEvent.EventType.REMOVED, Attrs.plotband.toString(), (Object)plotLine, new DeferredCall(){

                public void execute(JSFunction func) {
                    func.callFunction("removePlotBand", plotLine.getId());
                }
            });
        }
    }

    public boolean isReversed() {
        return this.getAttr(DAttrs.reversed, false).asBoolean();
    }

    public void setReversed(boolean reversed) {
        this.setAttr(DAttrs.reversed, reversed);
    }

    public boolean isShowEmpty() {
        return this.getAttr(DAttrs.showEmpty, true).asBoolean();
    }

    public void setShowEmpty(boolean showEmpty) {
        this.setAttr(DAttrs.showEmpty, showEmpty);
    }

    public boolean isShowFirstLabel() {
        return this.getAttr(DAttrs.showFirstLabel, true).asBoolean();
    }

    public void setShowFirstLabel(boolean showFirstLabel) {
        this.setAttr(DAttrs.showFirstLabel, showFirstLabel);
    }

    public boolean isShowLastLabel() {
        return this.getAttr(DAttrs.showLastLabel, false).asBoolean();
    }

    public void setShowLastLabel(boolean showLastLabel) {
        this.setAttr(DAttrs.showLastLabel, showLastLabel);
    }

    public Number getStartOfWeek() {
        return this.getAttr(DAttrs.startOfWeek, 1).asNumber();
    }

    public void setStartOfWeek(Number startOfWeek) {
        this.setAttr((PlotAttribute)DAttrs.startOfWeek, startOfWeek, Integer.valueOf(1));
    }

    public boolean isStartOnTick() {
        return this.getAttr(DAttrs.startOnTick, false).asBoolean();
    }

    public void setStartOnTick(boolean startOnTick) {
        this.setAttr(DAttrs.startOnTick, startOnTick);
    }

    public String getTickColor() {
        return this.getAttr(DAttrs.tickColor, "#C0D0E0").asString();
    }

    public void setTickColor(String tickColor) {
        this.setAttr((PlotAttribute)DAttrs.tickColor, tickColor, "#C0D0E0");
    }

    public Number getTickInterval() {
        return this.getAttr(DAttrs.tickInterval, null).asNumber();
    }

    public void setTickInterval(Number tickInterval) {
        this.setAttr(DAttrs.tickInterval, tickInterval);
    }

    public Number getTickLength() {
        return this.getAttr(DAttrs.tickLength, 5).asNumber();
    }

    public void setTickLength(Number tickLength) {
        this.setAttr((PlotAttribute)DAttrs.tickLength, tickLength, NOT_NULL_VALUE);
    }

    public Number getTickPixelInterval() {
        return this.getAttr(DAttrs.tickPixelInterval, null).asNumber();
    }

    public void setTickPixelInterval(Number tickPixelInterval) {
        this.setAttr(DAttrs.tickPixelInterval, tickPixelInterval);
    }

    public String getTickPosition() {
        return this.getAttr(DAttrs.tickPosition, "outside").asString();
    }

    public void setTickPosition(String tickPosition) {
        if (!"inside".equals(tickPosition) && !"outside".equals(tickPosition)) {
            throw new IllegalArgumentException("Unsupported position: [" + tickPosition + "]");
        }
        this.setAttr((PlotAttribute)DAttrs.tickPosition, tickPosition, NOT_NULL_VALUE);
    }

    public List<Number> getTickPositions() {
        return (List)Generics.cast((Object)this.getAttr(DAttrs.tickPositions, null).asValue());
    }

    public void setTickPositions(List<Number> tickPositions) {
        this.setAttr(DAttrs.tickPositions, tickPositions);
    }

    public Number getTickWidth() {
        return this.getAttr(DAttrs.tickWidth, 1).asNumber();
    }

    public void setTickWidth(Number tickWidth) {
        this.setAttr((PlotAttribute)DAttrs.tickWidth, tickWidth, Integer.valueOf(1));
    }

    public String getTickmarkPlacement() {
        return this.getAttr(DAttrs.tickmarkPlacement, "between").asString();
    }

    public void setTickmarkPlacement(String tickmarkPlacement) {
        if (!"on".equals(tickmarkPlacement) && !"between".equals(tickmarkPlacement)) {
            throw new IllegalArgumentException("Unsupported tickmark placement: [" + tickmarkPlacement + "]");
        }
        this.setAttr((PlotAttribute)DAttrs.tickmarkPlacement, tickmarkPlacement, "between");
    }

    public AxisTitle getTitle() {
        AxisTitle title = (AxisTitle)this.getAttr(DAttrs.title);
        if (title == null) {
            title = new AxisTitle();
            this.setTitle(title);
        }
        return title;
    }

    public void setTitle(AxisTitle title) {
        this.setAttr(DAttrs.title, title);
    }

    public void setTitle(String title) {
        this.getTitle().setText(title);
    }

    public String getType() {
        return this.getAttr(DAttrs.type, "linear").asString();
    }

    public void setType(String type) {
        if (!("linear".equals(type) || "logarithmic".equals(type) || "datetime".equals(type) || "category".equals(type))) {
            throw new IllegalArgumentException("Unsupported type: [" + type + "]");
        }
        this.setAttr((PlotAttribute)DAttrs.type, type, "linear");
    }

    public void remove() {
        this.fireEvent(OptionDataEvent.EventType.DESTROYED, "axis", (Object)this, new DeferredCall(){

            public void execute(JSFunction func) {
                func.callFunction("remove");
            }
        });
        this.clearOptonDataListener();
    }

    @Override
    public void onChange(OptionDataEvent event) {
        final Optionable target = event.getTarget();
        event.setCurrentTarget(this);
        event.addJSFunctionCall(new DeferredCall(){

            public void execute(JSFunction func) {
                if (target instanceof AxisLabels) {
                    JSONObject json = new JSONObject();
                    json.put((Object)"labels", (Object)target);
                    func.callFunction("update", json);
                } else if (target instanceof AxisTitle) {
                    func.callFunction("setTitle", target);
                } else if (target instanceof DateTimeLabelFormats) {
                    JSONObject json = new JSONObject();
                    json.put((Object)"dateTimeLabelFormats", (Object)target);
                    func.callFunction("update", json);
                } else {
                    func.callFunction("update", target);
                }
            }
        });
        this.fireEvent(event);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Attrs implements PlotAttribute
    {
        plotBands,
        plotLines,
        plotband,
        plotLine;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DAttrs implements PlotAttribute,
    DynamicalAttribute
    {
        allowDecimals,
        alternateGridColor,
        categories,
        dateTimeLabelFormats,
        endOnTick,
        events,
        gridLineColor,
        gridLineDashStyle,
        gridLineInterpolation,
        gridLineWidth,
        id,
        labels,
        lineColor,
        lineWidth,
        linkedTo,
        max,
        maxPadding,
        min,
        minPadding,
        minRange,
        minTickInterval,
        minorGridLineColor,
        minorGridLineDashStyle,
        minorGridLineWidth,
        minorTickColor,
        minorTickInterval,
        minorTickLength,
        minorTickPosition,
        minorTickWidth,
        offset,
        opposite,
        pane,
        reversed,
        showEmpty,
        showFirstLabel,
        showLastLabel,
        startOfWeek,
        startOnTick,
        tickColor,
        tickInterval,
        tickLength,
        tickPixelInterval,
        tickPosition,
        tickPositioner,
        tickPositions,
        tickWidth,
        tickmarkPlacement,
        title,
        type;

    }
}

