/** ResponseDataHandler.java.

	Purpose:
		
	Description:
		
	History:
		12:25:47 PM Jan 27, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.zkoss.chart.Axis;
import org.zkoss.chart.Charts;
import org.zkoss.chart.OptionDataEvent;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.OptionDataEvent.EventType;
import org.zkoss.chart.Series;
import org.zkoss.json.JSONAware;

/**
 * A response data handler for {@link Charts}'s smart update changes.
 * The handler can merge the duplicated data changes and ignore the changes if
 * they are unnecessary. For example add a new series with multiple points that
 * the <code>addPoint</code> command changes are unnecessary in this case.
 * This handler is used when the component is going to output the data in JSON
 * string at rendering phase, so it is a good timing to merge the response data there.
 * 
 * @author jumperchen
 */
public class ResponseDataHandler implements JSONAware {
	private Map<Optionable, List<OptionDataEvent>> _queue = new LinkedHashMap<Optionable, List<OptionDataEvent>>();
	
	public void addQueue(OptionDataEvent event) {
		List<OptionDataEvent> list = _queue.get(event.getTarget());
		if (list == null) {
			list = new LinkedList<OptionDataEvent>();
			_queue.put(event.getTarget(), list);
		}
		// clear all response data when destroy an optionable object which is not initialized yet. 
		if (event.getType() == EventType.DESTROYED) {
			for(OptionDataEvent evt : list) {
				if (evt.getType() == EventType.INITIALIZED) {
					list.clear();
					return;
				}
			}
		}
		list.add(event);
	}

	public boolean isEmpty() {
		return _queue.isEmpty();
	}
	public void clear() {
		_queue.clear();
	}
	public String toJSONString() {
		if (isEmpty())
			return "null";
		List<OptionDataEvent> response = new LinkedList<OptionDataEvent>();
		for (Map.Entry<Optionable, List<OptionDataEvent>> me : _queue.entrySet()) {
			boolean hasClassOperation = false;
			boolean hasUpdateFunction = false;
			if (me.getKey() instanceof Axis || me.getKey() instanceof Series) {// refer to PlotData.java
				for(OptionDataEvent evt : me.getValue()) {
					if (evt.getType() == EventType.INITIALIZED || evt.getType() == EventType.DESTROYED) {
						hasClassOperation = true;
						break;
					} else if (evt.isJSUpldateCall()) {
						hasUpdateFunction = true;
					}
				}
			} else {
				for(OptionDataEvent evt : me.getValue()) {
					if (evt.getType() == EventType.INITIALIZED || evt.getType() == EventType.DESTROYED) {
						hasClassOperation = true;
						break;
					}
				}
			}
			
			if (hasClassOperation) {
				List<OptionDataEvent> value = me.getValue();
				for (Iterator<OptionDataEvent> it = value.iterator(); it.hasNext();) {
					OptionDataEvent evt = it.next();
					if (evt.getType() != EventType.INITIALIZED && evt.getType() != EventType.DESTROYED) {
						it.remove();
					}
				}
			}
			if (hasUpdateFunction) {
				List<OptionDataEvent> value = me.getValue();
				for (Iterator<OptionDataEvent> it = value.iterator(); it.hasNext();) {
					OptionDataEvent evt = it.next();
					if (!evt.isJSUpldateCall()) {
						it.remove();
					}
				}
			}
			response.addAll(me.getValue());
		}
		return OptionsList.toJSONString(response);
	}
}
