/** OptionsMap.java.

	Purpose:
		
	Description:
		
	History:
		4:35:25 PM Mar 5, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart.util;

import java.util.LinkedHashMap;

import org.zkoss.json.JSONAware;
import org.zkoss.json.JSONObject;

/**
 * An options map helper.
 * 
 * @author jumperchen
 */
public class OptionsMap<K, V> extends LinkedHashMap<String, Object> implements JSONAware {
	private static final long serialVersionUID = 20140305164522l;
	private JSONAware _parent;
	public OptionsMap() {
		this(3);
	}

    /**
     * Constructs an empty insertion-ordered <tt>OptionsMap</tt> instance
     * with the specified initial capacity and a default load factor (0.75).
     *
     * @param  initialCapacity the initial capacity
     * @throws IllegalArgumentException if the initial capacity is negative
     */
	public OptionsMap(int initialCapacity) {
		super(initialCapacity);
	}
	
	/**
	 * Returns the parent options either {@link OptionsMap} or {@link OptionsList}.
	 * If null, that means the option is root object.
	 */
	public JSONAware getParent() {
		return _parent;
	}
	
	// internal use only
	void setParent(JSONAware parent) {
		_parent = parent;
	}
	
	/**
	 * Constructs an empty insertion-ordered <tt>OptionsMap</tt> instance
     * with the specified a key with a value.
     * @see #put(Object, Object)
	 */
	public OptionsMap(String key, Object value) {
		this(3);
		this.put(key, value);
	}
	/**
	 * Constructs an empty insertion-ordered <tt>OptionsMap</tt> instance
     * with the specified pairs that contain keys with values.
     * @see #put(Object, Object)
	 */
	public OptionsMap(Object... pairs) {
		this(3);
		for (int i = 0; i < pairs.length; i+=2) {
			put(pairs[i].toString(), pairs[i+1]);
		}
	}
	
	/**
	 * Adds the key with the value into the map.
	 * 
	 * @return the instance itself.
	 */
	public OptionsMap<K, V> add(String key, Object value) {
		this.put(key, value);
		return this;
	}
	
	/**
	 * Adds to create a nested options list with the given key.
	 * @return a nested options list
	 */
	public <E> OptionsList<E> addNestedList(String key) {
		OptionsList<E> e = new OptionsList<E>();
		this.put(key, e);
		e.setParent(this);
		return e;
	}
	
	/**
	 * Adds to create a nested options map with the given key.
	 * @return a nested options map
	 */
	public OptionsMap<K, V> addNestedMap(String key) {
		OptionsMap<K, V> map = new OptionsMap<K, V>(3);
		this.put(key, map);
		map.setParent(this);
		return map;
	}
	
	public String toJSONString() {
		return JSONObject.toJSONString(this);
	}


	/** Encodes this object to a JSON string.
	 * It is the same as {@link #toJSONString()}.
	 */	
	public String toString(){
		return toJSONString();
	}
}
