/** OptionsList.java.

	Purpose:
		
	Description:
		
	History:
		4:41:38 PM Mar 5, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
 */
package org.zkoss.chart.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONAware;
import org.zkoss.json.JSONValue;

/**
 * An options list helper.
 * 
 * @author jumperchen
 */
public class OptionsList<E> extends LinkedList<Object> implements JSONAware {
	private static final long serialVersionUID = 20140305164523l;
	private JSONAware _parent;

	/**
	 * Constructs an empty list.
	 */
	public OptionsList() {
	}

	/**
	 * Constructs a list containing the elements of the specified collection, in
	 * the order they are returned by the collection's iterator.
	 * 
	 * @param c
	 *            the collection whose elements are to be placed into this list
	 * @throws NullPointerException
	 *             if the specified collection is null
	 */
	public OptionsList(Collection<? extends E> c) {
		this();
		addAll(c);
	}
	
	/**
	 * Returns the parent options either {@link OptionsMap} or {@link OptionsList}.
	 * If null, that means the option is root object.
	 */
	public JSONAware getParent() {
		return _parent;
	}

	// internal use only
	void setParent(JSONAware parent) {
		_parent = parent;
	}

	
	/**
	 * Adds the value into the list.
	 * 
	 * @return the instance itself.
	 */
	public OptionsList<E> append(Object value) {
		super.add(value);
		return this;
	}
	
	/**
	 * Adds to create a nested options list with the given values.
	 * @return a nested options list
	 */
	public OptionsList<Object> addNestedList(Object... values) {
		OptionsList<Object> e = new OptionsList<Object>();
		e.addAll(Arrays.asList(values));
		this.add(e);
		e.setParent(this);
		return e;
	}
	
	/**
	 * Adds to create a nested options map with the given key and value pairs.
	 * @return a nested options map
	 */
	public OptionsMap<String, Object> addNestedMap(Object... pairs) {
		OptionsMap<String, Object> map = new OptionsMap<String, Object>(3);
		for (int i = 0; i < pairs.length; i+=2) {
			map.add(pairs[i].toString(), pairs[i+1]);
		}
		add(map);
		map.setParent(this);
		return map;
	}

	public String toJSONString() {
		return JSONArray.toJSONString(this);
	}

	/**
	 * Encodes this object to a JSON string. It is the same as
	 * {@link #toJSONString()}.
	 */
	public String toString() {
		return toJSONString();
	}
	
	// referred from JSONArray in ZK 7 version
	public static String toJSONString(Collection collection){
		if(collection == null)
			return "null";
		
        boolean first = true;
        StringBuffer sb = new StringBuffer();
		Iterator iter=collection.iterator();
        
        sb.append('[');
		while(iter.hasNext()){
            if(first)
                first = false;
            else
                sb.append(',');
            
			Object value=iter.next();
			if(value == null){
				sb.append("null");
				continue;
			}
			sb.append(JSONValue.toJSONString(value));
		}
        sb.append(']');
		return sb.toString();
	}

}
