/** MapsHelper.java.

	Purpose:
		
	Description:
		
	History:
		10:13:31 AM Mar 19, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
 */
package org.zkoss.chart.util;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.zkoss.lang.Strings;
import org.zkoss.mesg.MCommon;
import org.zkoss.util.IllegalSyntaxException;

/**
 * @author jumperchen
 */
public class MapsHelper {
	@SuppressWarnings("unchecked")
	public static final Map<? super String, ? super String> parse(
			Map<? super String, ? super String> map, String src,
			char pairSeparator, char separator, char quote)
			throws IllegalSyntaxException {
		return parse0(map, src, pairSeparator, separator, quote, false, false,
				false);
	}

	@SuppressWarnings("rawtypes")
	private static final Map parse0(Map map, String src, char pairSeparator,
			char separator, char quote, boolean asValue, boolean parenthesis,
			boolean multiple) throws IllegalSyntaxException {
		if (separator == (char) 0)
			throw new IllegalArgumentException("Separator cannot be 0");
		if (map == null)
			map = new HashMap<String, String>();
		if (src == null || src.length() == 0)
			return map; // nothing to do

		// prepare delimiters for keys and values.
		final String delimValue, delimKey;
		final boolean sngldblquote = quote == (char) 1;
		{
			final StringBuffer delimsb = new StringBuffer().append(separator);

			if (sngldblquote) {
				delimsb.append("\"'");
				quote = '"';
			} else if (quote != (char) 0) {
				delimsb.append(quote);
			}

			delimValue = delimsb.toString();
			delimKey = delimsb.append(pairSeparator).toString();
		}

		// parse
		for (int j = 0, len = src.length();;) {
			// handle name
			Token tk = next(src, delimKey, j, true, parenthesis);
			// if (log.finerable()) log.finer("name: "+tk.token+" "+tk.cc);
			j = tk.next;
			String name = tk.token;
			if (tk.cc == pairSeparator) {
				if (name.length() == 0)
					throw newIllegalSyntaxException(
							MCommon.UNEXPECTED_CHARACTER, tk.cc, src);
				++j; // skip =
			} else if (tk.cc == (char) 0) {
				// assert tk.next >= len;
				if (name.length() > 0)
					if (asValue)
						put(map, null, name, multiple);
					else
						put(map, name, null, multiple);
				return map;// done
			} else {
				if (quote != (char) 0
						&& (tk.cc == quote || (sngldblquote && tk.cc == '\''))) {
					name = null;
					// value only
				} else {
					// If separator is ' ', tk.cc can be anything; see next()
					if ((separator != ' ' && tk.cc != separator)
							|| name.length() == 0)
						throw newIllegalSyntaxException(
								MCommon.UNEXPECTED_CHARACTER, tk.cc, src);

					if (asValue)
						put(map, null, name, multiple);
					else
						put(map, name, null, multiple);
					if (tk.cc == separator)
						++j; // skip separator
					continue;
				}
			}

			// handle value
			tk = next(src, delimValue, j, false, parenthesis);
			// if (log.finerable()) log.finer("value: "+tk.token+" "+tk.cc);
			j = tk.next;
			final String value = tk.token;
			if (quote != (char) 0
					&& (tk.cc == quote || (sngldblquote && tk.cc == '\''))) {
				if (value.length() > 0)
					throw newIllegalSyntaxException(
							MCommon.UNEXPECTED_CHARACTER, tk.cc, src);

				final StringBuffer valsb = new StringBuffer(32);
				for (;;) {
					if (++j == len)
						throw newIllegalSyntaxException(
								MCommon.EXPECTING_CHARACTER, tk.cc, src);

					final char cc = src.charAt(j);
					if (cc == tk.cc)
						break;
					valsb.append(cc == '\\' ? escape(src, ++j) : cc);
				}
				put(map, name, valsb.toString(), multiple);
				++j; // skip the closing ' or "
			} else {
				put(map, name, value, multiple);
			}

			if (separator != ' ') {
				// If not ' ', ensure the following is a separator
				j = Strings.skipWhitespaces(src, j);
				if (j >= len)
					return map;
				if (src.charAt(j) != separator)
					throw newIllegalSyntaxException(
							MCommon.EXPECTING_CHARACTER, separator, src);
				++j; // skip separator
			}
		}
	}

	@SuppressWarnings("unchecked")
	private static void put(Map map, String name, String value, boolean multiple) {
		if (multiple) {
			List l = (List) map.get(name);
			if (l == null)
				map.put(name, l = new LinkedList());
			l.add(value);
		} else {
			map.put(name, value);
		}
	}

	/**
	 * Returns the ending parenthesis (such as }), or (char)0 if cc is not the
	 * beginning parenthesis (such as {).
	 */
	private static final char getEndingParenthesis(char cc) {
		return cc == '{' ? '}' : cc == '(' ? ')' : cc == '[' ? ']' : (char) 0;
	}

	/**
	 * Skip the string enclosed by a pair of parenthesis and return index after
	 * the ending parenthesis.
	 * 
	 * @param j
	 *            the index of the starting parenthesis
	 */
	private static int skipParenthesis(String src, int j, char beg, char end) {
		for (int len = src.length(), depth = 0; ++j < len;) {
			final char cc = src.charAt(j);
			if (cc == '\\')
				++j; // skip next
			else if (cc == beg)
				++depth;
			else if (cc == end && --depth < 0)
				break;
		}
		return j;
	}

	private static final char escape(String src, int j) {
		if (j >= src.length())
			throw new IllegalSyntaxException(MCommon.ILLEGAL_CHAR, "\\");
		final char cc = src.charAt(j);
		return cc == 'n' ? '\n' : cc == 't' ? '\t' : cc;
	}

	private static final IllegalSyntaxException newIllegalSyntaxException(
			int code, char cc, String src) {
		return new IllegalSyntaxException(code, new Object[] {
				new Character(cc), src });
	}

	private static class Token {
		/** The next position right after token. */
		private final int next;
		/** The character before next. */
		private final char cc;
		/** The token before next. */
		private final String token;

		private Token(int next, char cc, String token) {
			this.next = next;
			this.cc = cc;
			this.token = token;
		}
	}

	private static final Token next(String src, String delimiters, int j,
			boolean whitespaceAware, boolean parenthesis) {
		final StringBuffer tksb = new StringBuffer(64);
		final int len = src.length();
		j = Strings.skipWhitespaces(src, j);
		for (; j < len; ++j) {
			final char cc = src.charAt(j), endparen;
			if (cc == '\\') {
				tksb.append(escape(src, ++j));
			} else if (delimiters.indexOf(cc) >= 0) {
				// note: cc might be a separator which might be a whitespace
				j = Strings.skipWhitespaces(src, j);
				break; // done
			} else if (Character.isWhitespace(cc)) {
				final int k = Strings.skipWhitespaces(src, j);
				// done if the following is nothing but whitespace or...
				if (whitespaceAware || k >= len
						|| delimiters.indexOf(src.charAt(k)) >= 0) {
					j = k;
					break; // done
				}
				if (j > k - 1) { // more than one whitespaces
					tksb.append(src.substring(j, k));
					j = k - 1; // j will increase by one later
				} else {
					tksb.append(cc);
				}
			} else if (parenthesis
					&& (endparen = getEndingParenthesis(cc)) != (char) 0) {
				int k = skipParenthesis(src, j, cc, endparen);
				if (k >= len)
					k = len - 1; // endparen not found
				tksb.append(src.substring(j, k + 1));
				j = k;
			} else if (cc == (char) 0) {
				throw newIllegalSyntaxException(MCommon.UNEXPECTED_CHARACTER,
						(char) 0, src);
			} else {
				tksb.append(cc);
			}
		}
		return new Token(j, j < len ? src.charAt(j) : (char) 0, tksb.toString());
	}
}
