/** DeferredCall.java.

	Purpose:
		
	Description:
		
	History:
		12:32:12 PM Jan 23, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart.util;

import org.zkoss.chart.OptionDataEvent;


/**
 * Used with {@link OptionDataEvent#addJSFunctionCall(DeferredCall)} to defer calling the result of the
 * JSFunction when the calls are unnecessary. Like in component rendering phase.
 * @author jumperchen
 */
public interface DeferredCall {
	
	/**
	 * Executes the method when necessary, i.e. when the status of the component
	 * need to send to client side. 
	 * @param func the JSFunction to update the client side. (never be null)
	 */
	public void execute(JSFunction func);
}
