/** AnyVal.java.

	Purpose:
		
	Description:
		
	History:
		2:55:59 PM Apr 12, 2013, Created by jumperchen

Copyright (C) 2013 Potix Corporation. All Rights Reserved.
 */
package org.zkoss.chart.util;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.zkoss.json.JSONAware;
import org.zkoss.json.JSONValue;
import org.zkoss.lang.Objects;

/**
 * AnyVal is the root class of all primitive types, which describe values not
 * implemented as objects in the underlying host system.
 * @author jumperchen
 */
public class AnyVal<T> implements JSONAware {
	private T _val;
	public AnyVal(T val) {
		_val = val;
	}
	/**
	 * Returns the origin value
	 */
	public Object asValue() {
		return _val;
	}
	/**
	 * Returns the origin value as int type, if possible.
	 */
	public int asInt() {
		if (_val == null)
			return 0;
		if (_val instanceof Double) {
			return ((Double) _val).intValue();
		} else if (_val instanceof String) {
			return Integer.parseInt((String)_val);
		}
		return (Integer) _val;
	}
	/**
	 * Returns the origin value as string type, if possible.
	 */
	public String asString() {
		if (_val == null)
			return null;
		return _val.toString();
	}
	/**
	 * Returns the origin value as boolean type, if possible.
	 */
	public boolean asBoolean() {
		if (_val == null)
			return false;
		return Boolean.valueOf(_val.toString());
	}
	/**
	 * Returns the origin value as number type, if possible.
	 */
	public Number asNumber() {
		if (_val == null)
			return new Integer(0);
		return (Number) _val;
	}
	/**
	 * Returns the origin value as long type, if possible.
	 */
	public long asLong() {
		if (_val == null)
			return 0;
		if (_val instanceof Float) {
			return ((Float) _val).longValue();
		} else if (_val instanceof String) {
			return Long.parseLong((String)_val);
		}
		return (Long) _val;
	}
	/**
	 * Returns the origin value as double type, if possible.
	 */
	public double asDouble() {
		if (_val == null)
			return 0;
		if (_val instanceof Integer) {
			return ((Integer) _val).doubleValue();
		} else if (_val instanceof String) {
			return Double.parseDouble((String)_val);
		}
		return (Double) _val;
	}
	/**
	 * Returns the origin value as float type, if possible.
	 */
	public float asFloat() {
		if (_val == null)
			return 0;
		if (_val instanceof Long) {
			return ((Long) _val).floatValue();
		} else if (_val instanceof String) {
			return Float.parseFloat((String)_val);
		}
		return (Float) _val;
	}
	/**
	 * Returns the origin value as short type, if possible.
	 */
	public short asShort() {
		if (_val == null)
			return 0;
		if (_val instanceof Integer) {
			return ((Integer) _val).shortValue();
		} else if (_val instanceof String) {
			return Short.parseShort((String)_val);
		}
		return (Short) _val;
	}
	/**
	 * Returns the origin value as char type, if possible.
	 */
	public char asChar() {
		if (_val == null)
			return 0;
		return (Character) _val;
	}
	/**
	 * Returns the origin value in byte type, if possible.
	 */
	public byte asByte() {
		if (_val == null)
			return 0;
		return (Byte) _val;
	}
	/**
	 * Returns the origin value as a list, if possible.
	 */
	public List<?> asList() {
		return (List<?>) _val;
	}
	/**
	 * Returns the origin value as a map, if possible.
	 */
	public Map<?, ?> asMap() {
		return (Map<?, ?>) _val;
	}
	/**
	 * Returns the origin value as a set, if possible.
	 */
	public Set<?> asSet() {
		return (Set<?>) _val;
	}
	/**
	 * Returns the origin value as an array, if possible.
	 */
	public Object[] asArray() {
		return (Object[]) _val;
	}
	/**
	 * Returns the origin value as Number array, if possible.
	 */
	public Number[] asNumberArray() {
		return (Number[]) _val;
	}
	/**
	 * Returns the origin value as int array, if possible.
	 */
	public int[] asIntArray() {
		return (int[]) _val;
	}
	/**
	 * Returns the origin value as float array, if possible.
	 */
	public float[] asFloatArray() {
		return (float[]) _val;
	}
	/**
	 * Returns the origin value as long array, if possible.
	 */
	public long[] asLongArray() {
		return (long[]) _val;
	}
	/**
	 * Returns the origin value as double array, if possible.
	 */
	public double[] asDoubleArray() {
		return (double[]) _val;
	}
	/**
	 * Returns the origin value as boolean array, if possible.
	 */
	public boolean[] asBooleanArray() {
		return (boolean[]) _val;
	}
	/**
	 * Returns the origin value as short array, if possible.
	 */
	public short[] asShortArray() {
		return (short[]) _val;
	}
	/**
	 * Returns the origin value as char array, if possible.
	 */
	public char[] asCharArray() {
		return (char[]) _val;
	}
	/**
	 * Returns the origin value as string array, if possible.
	 */
	public String[] asStringArray() {
		return (String[]) _val;
	}
	/**
	 * Returns the origin value as byte array, if possible.
	 */
	public byte[] asByteArray() {
		return (byte[]) _val;
	}
	public int hashCode() {
		if (_val != null)
			return _val.hashCode();
		return super.hashCode();
	}
	@SuppressWarnings("rawtypes")
	public boolean equals(Object obj) {
		if (obj != this) {
			if (obj instanceof AnyVal) {
				return Objects.equals(_val, ((AnyVal) obj)._val);
			}
			return Objects.equals(_val, ((AnyVal) obj)._val);
		}
		return true;
	}
	public String toString() {
		return String.valueOf(_val);
	}
	public String toJSONString() {
		return JSONValue.toJSONString(_val);
	}
}
