/* WaterfallPlotOptions.java

	Purpose:
		
	Description:
		
	History:
		Thu, Jan 16, 2014  3:58:58 PM, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

 */
package org.zkoss.chart.plotOptions;

import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.util.DynamicalAttribute;

/**
 * An option for waterfall plot
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author RaymondChao
 */
public class WaterfallPlotOptions extends ColumnPlotOptions {

	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		borderColor, dashStyle, lineColor, upColor
	}

	/**
	 * Returns the color of the border of each waterfall column.
	 * <p>
	 * Default: #333333
	 */
	public Color getBorderColor() {
		if (!containsKey(Attrs.borderColor)) {
			setBorderColor("#333333");
		}
		return (Color) getAttr(Attrs.borderColor);
	}

	/**
	 * Sets the color of the border of each waterfall column.
	 */
	public void setBorderColor(Color color) {
		setAttr(Attrs.borderColor, color, NOT_NULL_VALUE);
	}

	/**
	 * Sets the color of the border of each waterfall column.
	 */
	public void setBorderColor(String color) {
		setBorderColor(new Color(color));
	}

	/**
	 * Sets the color of the border of each waterfall column.
	 */
	public void setBorderColor(LinearGradient color) {
		setBorderColor(new Color(color));
	}

	/**
	 * Sets the color of the border of each waterfall column.
	 */
	public void setBorderColor(RadialGradient color) {
		setBorderColor(new Color(color));
	}

	/**
	 * Returns a name for the dash style to use for the line connecting the
	 * columns of the waterfall series. Possible values:
	 * <ul>
	 * <li>Solid</li>
	 * <li>ShortDash</li>
	 * <li>ShortDot</li>
	 * <li>ShortDashDot</li>
	 * <li>ShortDashDotDot</li>
	 * <li>Dot</li>
	 * <li>Dash</li>
	 * <li>LongDash</li>
	 * <li>DashDot</li>
	 * <li>LongDashDot</li>
	 * <li>LongDashDotDot</li>
	 * </ul>
	 */
	public String getDashStyle() {
		return getAttr(Attrs.dashStyle, "Dot").asString();
	}

	/**
	 * Sets a name for the dash style to use for the line connecting the columns
	 * of the waterfall series. Possible values:
	 * <ul>
	 * <li>Solid</li>
	 * <li>ShortDash</li>
	 * <li>ShortDot</li>
	 * <li>ShortDashDot</li>
	 * <li>ShortDashDotDot</li>
	 * <li>Dot</li>
	 * <li>Dash</li>
	 * <li>LongDash</li>
	 * <li>DashDot</li>
	 * <li>LongDashDot</li>
	 * <li>LongDashDotDot</li>
	 * </ul>
	 */
	public void setDashStyle(String dashStyle) {
		if (!("Solid".equalsIgnoreCase(dashStyle)
				|| "ShortDash".equalsIgnoreCase(dashStyle)
				|| "ShortDot".equalsIgnoreCase(dashStyle)
				|| "ShortDashDot".equalsIgnoreCase(dashStyle)
				|| "ShortDashDotDot".equalsIgnoreCase(dashStyle)
				|| "Dot".equalsIgnoreCase(dashStyle)
				|| "Dash".equalsIgnoreCase(dashStyle)
				|| "LongDash".equalsIgnoreCase(dashStyle)
				|| "DashDot".equalsIgnoreCase(dashStyle)
				|| "LongDashDot".equalsIgnoreCase(dashStyle) || "LongDashDotDot"
					.equalsIgnoreCase(dashStyle)))
			throw new IllegalArgumentException("Unsupported style: ["
					+ dashStyle + "]");
		setAttr(Attrs.dashStyle, dashStyle, "Dot");
	}

	/**
	 * Returns the color of the line that connects columns in a waterfall
	 * series.
	 * <p>
	 * Default: #333333
	 */
	public Color getLineColor() {
		if (!containsKey(Attrs.lineColor)) {
			setLineColor("#333333");
		}
		return (Color) getAttr(Attrs.lineColor);
	}

	/**
	 * Sets the color of the line that connects columns in a waterfall series.
	 */
	public void setLineColor(Color color) {
		setAttr(Attrs.lineColor, color, NOT_NULL_VALUE);
	}

	/**
	 * Sets the color of the line that connects columns in a waterfall series.
	 */
	public void setLineColor(String color) {
		setLineColor(new Color(color));
	}

	/**
	 * Sets the color of the line that connects columns in a waterfall series.
	 */
	public void setLineColor(LinearGradient color) {
		setLineColor(new Color(color));
	}

	/**
	 * Sets the color of the line that connects columns in a waterfall series.
	 */
	public void setLineColor(RadialGradient color) {
		setLineColor(new Color(color));
	}
	
	/**
	 * Returns the color of up point in a waterfall series.
	 * series.
	 * <p>
	 * Default: null
	 */
	public Color getUpColor() {
		if (!containsKey(Attrs.upColor)) {
			setLineColor((String) null);
		}
		return (Color) getAttr(Attrs.upColor);
	}
	
	/**
	 * Sets the color of up point in a waterfall series.
	 */
	public void setUpColor(Color color) {
		setAttr(Attrs.upColor, color, NOT_NULL_VALUE);
	}
	
	/**
	 * Sets the color of up point in a waterfall series.
	 */
	public void setUpColor(String color) {
		setUpColor(new Color(color));
	}

	/**
	 * Sets the color of up point in a waterfall series.
	 */
	public void setUpColor(LinearGradient color) {
		setUpColor(new Color(color));
	}

	/**
	 * Sets the color of up point in a waterfall series.
	 */
	public void setUpColor(RadialGradient color) {
		setUpColor(new Color(color));
	}

}