/* ScatterPlotOptions.java

	Purpose:
		
	Description:
		
	History:
		Thu, Jan 16, 2014  3:58:41 PM, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

 */
package org.zkoss.chart.plotOptions;

import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.util.DynamicalAttribute;

/**
 * An option for scatter plot
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author RaymondChao
 */
public class ScatterPlotOptions extends SeriesPlotOptions {
	private enum Attrs implements PlotAttribute {
		lineWidth, stickyTracking
	}

	/**
	 * Returns the width of the line connecting the data points.
	 * <p>Default: 0
	 */
	public Number getLineWidth() {
		return getAttr(Attrs.lineWidth, 0).asNumber();
	}

	/**
	 * Sets the width of the line connecting the data points. 'lineWidth the
	 * width of the line connecting the data points.
	 */
	public void setLineWidth(Number lineWidth) {
		setAttr(Attrs.lineWidth, lineWidth, 0);
	}

	/**
	 * Returns sticky tracking of mouse events. When true, the
	 * <code>mouseOut</code> event on a series isn't triggered until the mouse
	 * moves over another series, or out of the plot area. When false, the
	 * <code>mouseOut</code> event on a series is triggered when the mouse
	 * leaves the area around the series' graph or markers. This also implies
	 * the tooltip. When <code>stickyTracking</code> is false and
	 * <code>tooltip.shared</code> is false, the tooltip will be hidden when
	 * moving the mouse between series.
	 */
	public boolean isStickyTracking() {
		return getAttr(Attrs.stickyTracking, false).asBoolean();
	}

	/**
	 * Sets sticky tracking of mouse events. When true, the
	 * <code>mouseOut</code> event on a series isn't triggered until the mouse
	 * moves over another series, or out of the plot area. When false, the
	 * <code>mouseOut</code> event on a series is triggered when the mouse
	 * leaves the area around the series' graph or markers. This also implies
	 * the tooltip. When <code>stickyTracking</code> is false and
	 * <code>tooltip.shared</code> is false, the tooltip will be hidden when
	 * moving the mouse between series.
	 */
	public void setStickyTracking(boolean stickyTracking) {
		setAttr(Attrs.stickyTracking, stickyTracking);
	}

}