/** RangeDataLabels.java.

	Purpose:
		
	Description:
		
	History:
		3:35:10 PM Feb 26, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
 */
package org.zkoss.chart.plotOptions;

import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.util.DynamicalAttribute;

/**
 * An option of data labels for range
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author jumperchen
 */
public class RangeDataLabels extends DataLabels {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		xHigh, xLow, yHigh, yLow
	}

	/**
	 * Returns X offset of the higher data labels relative to the point value.
	 * <p>
	 * Defaults to 0.
	 */
	public Number getXHigh() {
		return getAttr(Attrs.xHigh, 0).asNumber();
	}

	/**
	 * Sets X offset of the higher data labels relative to the point value.
	 * <p>
	 * Defaults to 0.
	 */
	public void setXHigh(Number xHigh) {
		setAttr(Attrs.xHigh, xHigh, 0);
	}


	/**
	 * Returns Y offset of the higher data labels relative to the point value.
	 * <p>
	 * Defaults to -6.
	 */
	public Number getYHigh() {
		return getAttr(Attrs.yHigh, -6).asNumber();
	}

	/**
	 * Sets Y offset of the higher data labels relative to the point value.
	 * <p>
	 * Defaults to -6.
	 */
	public void setYHigh(Number yHigh) {
		setAttr(Attrs.yHigh, yHigh, -6);
	}


	/**
	 * Returns X offset of the lower data labels relative to the point value
	 * <p>
	 * Defaults to 0.
	 */
	public Number getXLow() {
		return getAttr(Attrs.xLow, 0).asNumber();
	}

	/**
	 * Sets X offset of the lower data labels relative to the point value
	 * <p>
	 * Defaults to 0.
	 */
	public void setXLow(Number xLow) {
		setAttr(Attrs.xLow, xLow, 0);
	}
	
	/**
	 * Returns Y offset of the lower data labels relative to the point value.
	 * <p>
	 * Defaults to 16.
	 */
	public Number getYLow() {
		return getAttr(Attrs.yLow, 16).asNumber();
	}

	/**
	 * Sets Y offset of the lower data labels relative to the point value.
	 * <p>
	 * Defaults to 16.
	 */
	public void setYLow(Number yLow) {
		setAttr(Attrs.yLow, yLow, 16);
	}
}
