/* PlotOptions.java

	Purpose:
		
	Description:
		
	History:
		Tue, Jan 14, 2014  9:43:00 PM, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

 */
package org.zkoss.chart.plotOptions;

import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.util.DynamicalAttribute;

/**
 * An option for all plots
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author RaymondChao
 */
public class PlotOptions extends Optionable {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		area,
		arearange,
		areaspline,
		areasplinerange,
		bar,
		boxplot,
		bubble,
		column,
		columnrange,
		errorbar,
		funnel,
		gauge,
		line,
		pie,
		scatter,
		series,
		spline,
		waterfall
	}

	/**
	 * Returns the area plot option
	 */
	public AreaPlotOptions getArea() {
		AreaPlotOptions areaPlotOptions = (AreaPlotOptions) getAttr(Attrs.area);
		if (areaPlotOptions == null) {
			areaPlotOptions = new AreaPlotOptions();
			setAttr(Attrs.area, areaPlotOptions);
		}
		return areaPlotOptions;
	}

	/**
	 * Returns the area range plot option
	 */
	public AreaRangePlotOptions getAreaRange() {
		AreaRangePlotOptions areaRangePlotOptions = (AreaRangePlotOptions) getAttr(Attrs.arearange);
		if (areaRangePlotOptions == null) {
			areaRangePlotOptions = new AreaRangePlotOptions();
			setAttr(Attrs.arearange, areaRangePlotOptions);
		}
		return areaRangePlotOptions;
	}
	
	/**
	 * Returns the areaspline plot option
	 */
	public AreaSplinePlotOptions getAreaSpline() {
		AreaSplinePlotOptions areaSplinePlotOptions = (AreaSplinePlotOptions) getAttr(Attrs.areaspline);
		if (areaSplinePlotOptions == null) {
			areaSplinePlotOptions = new AreaSplinePlotOptions();
			setAttr(Attrs.areaspline, areaSplinePlotOptions);
		}
		return areaSplinePlotOptions;
	}

	/**
	 * Returns the areaspline range plot option
	 */
	public AreaSplineRangePlotOptions getAreaSplineRange() {
		AreaSplineRangePlotOptions areaSplineRangePlotOptions = (AreaSplineRangePlotOptions) getAttr(Attrs.areasplinerange);
		if (areaSplineRangePlotOptions == null) {
			areaSplineRangePlotOptions = new AreaSplineRangePlotOptions();
			setAttr(Attrs.areasplinerange, areaSplineRangePlotOptions);
		}
		return areaSplineRangePlotOptions;
	}

	/**
	 * Returns the bar plot option
	 */
	public BarPlotOptions getBar() {
		BarPlotOptions barPlotOptions = (BarPlotOptions) getAttr(Attrs.bar);
		if (barPlotOptions == null) {
			barPlotOptions = new BarPlotOptions();
			setAttr(Attrs.bar, barPlotOptions);
		}
		return barPlotOptions;
	}

	/**
	 * Returns the box plot option
	 */
	public BoxPlotOptions getBoxPlot() {
		BoxPlotOptions boxPlotOptions = (BoxPlotOptions) getAttr(Attrs.boxplot);
		if (boxPlotOptions == null) {
			boxPlotOptions = new BoxPlotOptions();
			setAttr(Attrs.boxplot, boxPlotOptions);
		}
		return boxPlotOptions;
	}

	/**
	 * Returns the bubble plot option
	 */
	public BubblePlotOptions getBubble() {
		BubblePlotOptions bubblePlotOptions = (BubblePlotOptions) getAttr(Attrs.bubble);
		if (bubblePlotOptions == null) {
			bubblePlotOptions = new BubblePlotOptions();
			setAttr(Attrs.bubble, bubblePlotOptions);
		}
		return bubblePlotOptions;
	}

	/**
	 * Returns the column plot option
	 */
	public ColumnPlotOptions getColumn() {
		ColumnPlotOptions columnPlotOptions = (ColumnPlotOptions) getAttr(Attrs.column);
		if (columnPlotOptions == null) {
			columnPlotOptions = new ColumnPlotOptions();
			setAttr(Attrs.column, columnPlotOptions);
		}
		return columnPlotOptions;
	}

	/**
	 * Returns the column range plot option
	 */
	public ColumnRangePlotOptions getColumnRange() {
		ColumnRangePlotOptions columnRangePlotOptions = (ColumnRangePlotOptions) getAttr(Attrs.columnrange);
		if (columnRangePlotOptions == null) {
			columnRangePlotOptions = new ColumnRangePlotOptions();
			setAttr(Attrs.columnrange, columnRangePlotOptions);
		}
		return columnRangePlotOptions;
	}

	/**
	 * Returns the error bar plot option
	 */
	public ErrorBarPlotOptions getErrorBar() {
		ErrorBarPlotOptions errorBarPlotOptions = (ErrorBarPlotOptions) getAttr(Attrs.errorbar);
		if (errorBarPlotOptions == null) {
			errorBarPlotOptions = new ErrorBarPlotOptions();
			setAttr(Attrs.errorbar, errorBarPlotOptions);
		}
		return errorBarPlotOptions;
	}

	/**
	 * Returns the funnel plot option
	 */
	public FunnelPlotOptions getFunnel() {
		FunnelPlotOptions funnelPlotOptions = (FunnelPlotOptions) getAttr(Attrs.funnel);
		if (funnelPlotOptions == null) {
			funnelPlotOptions = new FunnelPlotOptions();
			setAttr(Attrs.funnel, funnelPlotOptions);
		}
		return funnelPlotOptions;
	}

	/**
	 * Returns the gauge plot option
	 */
	public GaugePlotOptions getGauge() {
		GaugePlotOptions gaugePlotOptions = (GaugePlotOptions) getAttr(Attrs.gauge);
		if (gaugePlotOptions == null) {
			gaugePlotOptions = new GaugePlotOptions();
			setAttr(Attrs.gauge, gaugePlotOptions);
		}
		return gaugePlotOptions;
	}

	/**
	 * Returns the line plot option
	 */
	public LinePlotOptions getLine() {
		LinePlotOptions linePlotOptions = (LinePlotOptions) getAttr(Attrs.line);
		if (linePlotOptions == null) {
			linePlotOptions = new LinePlotOptions();
			setAttr(Attrs.line, linePlotOptions);
		}
		return linePlotOptions;
	}

	/**
	 * Returns the pie plot option
	 */
	public PiePlotOptions getPie() {
		PiePlotOptions piePlotOptions = (PiePlotOptions) getAttr(Attrs.pie);
		if (piePlotOptions == null) {
			piePlotOptions = new PiePlotOptions();
			setAttr(Attrs.pie, piePlotOptions);
		}
		return piePlotOptions;
	}


	/**
	 * Returns the scatter plot option
	 */
	public ScatterPlotOptions getScatter() {
		ScatterPlotOptions scatterPlotOptions = (ScatterPlotOptions) getAttr(Attrs.scatter);
		if (scatterPlotOptions == null) {
			scatterPlotOptions = new ScatterPlotOptions();
			setAttr(Attrs.scatter, scatterPlotOptions);
		}
		return scatterPlotOptions;
	}

	/**
	 * Returns the series plot option
	 */
	public SeriesPlotOptions getSeries() {
		SeriesPlotOptions seriesPlotOptions = (SeriesPlotOptions) getAttr(Attrs.series);
		if (seriesPlotOptions == null) {
			seriesPlotOptions = new SeriesPlotOptions();
			setAttr(Attrs.series, seriesPlotOptions);
		}
		return seriesPlotOptions;
	}

	/**
	 * Returns the spline plot option
	 */
	public SplinePlotOptions getSpline() {
		SplinePlotOptions splinePlotOptions = (SplinePlotOptions) getAttr(Attrs.spline);
		if (splinePlotOptions == null) {
			splinePlotOptions = new SplinePlotOptions();
			setAttr(Attrs.spline, splinePlotOptions);
		}
		return splinePlotOptions;
	}

	/**
	 * Returns the water fall plot option
	 */
	public WaterfallPlotOptions getWaterfall() {
		WaterfallPlotOptions waterfallPlotOptions = (WaterfallPlotOptions) getAttr(Attrs.waterfall);
		if (waterfallPlotOptions == null) {
			waterfallPlotOptions = new WaterfallPlotOptions();
			setAttr(Attrs.waterfall, waterfallPlotOptions);
		}
		return waterfallPlotOptions;
	}
}
