/** PieDataLabels.java.

	Purpose:
		
	Description:
		
	History:
		4:47:19 PM Mar 6, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
 */
package org.zkoss.chart.plotOptions;

import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.util.DynamicalAttribute;

/**
 * An option of data labels used for Pie and Funnel
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author jumperchen
 */
public class PieDataLabels extends DataLabels {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		connectorWidth, connectorColor, connectorPadding,

		// override
		distance,
		enabled
	}

	/**
	 * Sets the distance from the data label to the connector.
	 * <p>Defaults to 5.
	 */
	public void setConnectorPadding(Number connectorPadding) {
		setAttr(Attrs.connectorPadding, connectorPadding, 5);
	}

	/**
	 * Returns the distance from the data label to the connector.
	 * <p>Defaults to 5.
	 */
	public Number getConnectorPadding() {
		return getAttr(Attrs.connectorPadding, 5).asNumber();
	}

	/**
	 * Sets the width of the line connecting the data label to the pie slice.
	 * <p>
	 * Defaults to 1
	 */
	public void setConnectorWidth(Number connectorWidth) {
		setAttr(Attrs.connectorWidth, connectorWidth, 1);
	}

	/**
	 * Returns the width of the line connecting the data label to the pie slice.
	 * <p>
	 * Defaults to 1
	 */
	public Number getConnectorWidth() {
		return getAttr(Attrs.connectorWidth, 1).asNumber();
	}

	/**
	 * Sets the color of the line connecting the data label to the pie slice.
	 * The default color is the same as the point's color.
	 * <p>
	 * Defaults to <tt>{point.color}</tt>.
	 */
	public void setConnectorColor(String connectorColor) {
		setAttr(Attrs.connectorColor, connectorColor, "{point.color}");
	}

	/**
	 * Returns the color of the line connecting the data label to the pie slice.
	 * The default color is the same as the point's color.
	 * <p>
	 * Defaults to <tt>{point.color}</tt>.
	 */
	public String getConnectorColor() {
		return getAttr(Attrs.connectorColor, "{point.color}").asString();
	}

	/**
	 * Returns the distance of the data labels which is used for Pie chart only.
	 * <p>
	 * Default: 30
	 */
	public Number getDistance() {
		return getAttr(Attrs.distance, 30).asNumber();
	}

	/**
	 * Sets the distance of the data labels which is used for Pie chart only.
	 */
	public void setDistance(Number distance) {
		setAttr(Attrs.distance, distance, 30);
	}

	/**
	 * Returns enable or disable the data labels.
	 * <p>
	 * Default: true
	 */
	public boolean isEnabled() {
		return getAttr(Attrs.enabled, true).asBoolean();
	}

	/**
	 * Sets enable or disable the data labels.
	 * <p>
	 * Default: true
	 */
	public void setEnabled(boolean enabled) {
		setAttr(Attrs.enabled, enabled);
	}
}
