/* LinePlotOptions.java

	Purpose:
		
	Description:
		
	History:
		Tue, Jan 14, 2014 11:18:57 PM, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

 */
package org.zkoss.chart.plotOptions;

import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.util.DynamicalAttribute;

/**
 * An option for line plot
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author RaymondChao
 */
public class LinePlotOptions extends SeriesPlotOptions {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		step
	}

	/**
	 * Returns whether to apply steps to the line. Possible values are
	 * <code>left</code>, <code>center</code> and <code>right</code>. Prior to
	 * 2.3.5, only <code>left</code> was supported.
	 */
	public String getStep() {
		return (String) getAttr(Attrs.step, null).asString();
	}

	/**
	 * Sets whether to apply steps to the line. Possible values are
	 * <code>left</code>, <code>center</code> and <code>right</code>. Prior to
	 * 2.3.5, only <code>left</code> was supported.
	 */
	public void setStep(String step) {
		setAttr(Attrs.step, step);
	}

}