/* GaugePlotOptions.java

	Purpose:
		
	Description:
		
	History:
		Thu, Jan 16, 2014  3:19:52 PM, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

 */
package org.zkoss.chart.plotOptions;

import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.util.DynamicalAttribute;

/**
 * An option for gauge plot.
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author RaymondChao
 */
public class GaugePlotOptions extends SeriesPlotOptions {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		dial, pivot, showInLegend, wrap
	}

	/**
	 * Returns options for the dial or arrow pointer of the gauge.
	 * <p>
	 * Default: an instance of {@link GaugeDialPlotOptions}.
	 */
	public GaugeDialPlotOptions getDial() {
		GaugeDialPlotOptions dial = (GaugeDialPlotOptions) getAttr(Attrs.dial);
		if (dial == null) {
			dial = new GaugeDialPlotOptions();
			setDial(dial);
		}
		return dial;
	}

	/**
	 * Sets options for the dial or arrow pointer of the gauge.
	 */
	public void setDial(GaugeDialPlotOptions dial) {
		setAttr(Attrs.dial, dial);
	}

	/**
	 * Returns options for the pivot or the center point of the gauge.
	 * <p>
	 * Default: an instance of {@link GaugePivotPlotOptions}.
	 */
	public GaugePivotPlotOptions getPivot() {
		GaugePivotPlotOptions pivot = (GaugePivotPlotOptions) getAttr(Attrs.pivot);
		if (pivot == null) {
			pivot = new GaugePivotPlotOptions();
			setPivot(pivot);
		}
		return pivot;
	}

	/**
	 * Sets options for the pivot or the center point of the gauge.
	 */
	public void setPivot(GaugePivotPlotOptions pivot) {
		setAttr(Attrs.pivot, pivot);
	}

	/**
	 * Returns whether to display this particular series or series type in the
	 * legend. Defaults to false for gauge series.
	 * <p>
	 * Default: false.
	 */
	public boolean getShowInLegend() {
		return getAttr(Attrs.showInLegend, false).asBoolean();
	}

	/**
	 * Sets whether to display this particular series or series type in the
	 * legend. Defaults to false for gauge series.
	 */
	public void setShowInLegend(boolean showInLegend) {
		setAttr(Attrs.showInLegend, showInLegend);
	}

	/**
	 * Returns when this option is <code>true</code>, the dial will wrap around
	 * the axes. For instance, in a full-range gauge going from 0 to 360, a
	 * value of 400 will point to 40. When <code>wrap</code> is
	 * <code>false</code>, the dial stops at 360.
	 * <p>
	 * Default: true.
	 */
	public boolean getWrap() {
		return getAttr(Attrs.wrap, true).asBoolean();
	}

	/**
	 * Sets when this option is <code>true</code>, the dial will wrap around the
	 * axes. For instance, in a full-range gauge going from 0 to 360, a value of
	 * 400 will point to 40. When <code>wrap</code> is <code>false</code>, the
	 * dial stops at 360.
	 */
	public void setWrap(boolean wrap) {
		setAttr(Attrs.wrap, wrap);
	}

}