/* GaugePivotPlotOptions.java

	Purpose:
		
	Description:
		
	History:
		Thu, Jan 16, 2014  3:21:44 PM, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

 */
package org.zkoss.chart.plotOptions;

import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.util.DynamicalAttribute;

/**
 * An option for gauge pivot plot.
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author RaymondChao
 */
public class GaugePivotPlotOptions extends Optionable {
	private enum Attrs implements PlotAttribute {
		backgroundColor, borderColor, borderWidth, radius
	}

	/**
	 * Returns the background color or fill of the pivot.
	 * <p>
	 * Default: "black".
	 */
	public Color getBackgroundColor() {
		if (!containsKey(Attrs.backgroundColor)) {
			setBackgroundColor("black");
		}
		return (Color) getAttr(Attrs.backgroundColor);
	}

	/**
	 * Sets the background color or fill of the pivot.
	 */
	public void setBackgroundColor(Color color) {
		setAttr(Attrs.backgroundColor, color, NOT_NULL_VALUE);
	}

	/**
	 * Sets the background color or fill of the pivot.
	 */
	public void setBackgroundColor(String color) {
		setBackgroundColor(new Color(color));
	}

	/**
	 * Sets the background color or fill of the pivot.
	 */
	public void setBackgroundColor(LinearGradient color) {
		setBackgroundColor(new Color(color));
	}

	/**
	 * Sets the background color or fill of the pivot.
	 */
	public void setBackgroundColor(RadialGradient color) {
		setBackgroundColor(new Color(color));
	}

	/**
	 * Returns the border or stroke color of the pivot. In able to change this,
	 * the borderWidth must also be set to something other than the default 0.
	 * <p>
	 * Default: "silver".
	 */
	public Color getBorderColor() {
		if (!containsKey(Attrs.borderColor)) {
			setBorderColor("silver");
		}
		return (Color) getAttr(Attrs.borderColor);
	}

	/**
	 * Sets the border or stroke color of the pivot. In able to change this, the
	 * borderWidth must also be set to something other than the default 0.
	 */
	public void setBorderColor(Color color) {
		setAttr(Attrs.borderColor, color, NOT_NULL_VALUE);
	}

	/**
	 * Sets the border or stroke color of the pivot. In able to change this, the
	 * borderWidth must also be set to something other than the default 0.
	 */
	public void setBorderColor(String color) {
		setBorderColor(new Color(color));
	}

	/**
	 * Sets the border or stroke color of the pivot. In able to change this, the
	 * borderWidth must also be set to something other than the default 0.
	 */
	public void setBorderColor(LinearGradient color) {
		setBorderColor(new Color(color));
	}

	/**
	 * Sets the border or stroke color of the pivot. In able to change this, the
	 * borderWidth must also be set to something other than the default 0.
	 */
	public void setBorderColor(RadialGradient color) {
		setBorderColor(new Color(color));
	}

	/**
	 * Returns the border or stroke width of the pivot.
	 * <p>
	 * Default: 0.
	 */
	public Number getBorderWidth() {
		return getAttr(Attrs.borderWidth, 0).asNumber();
	}

	/**
	 * Sets the border or stroke width of the pivot.
	 */
	public void setBorderWidth(Number borderWidth) {
		setAttr(Attrs.borderWidth, borderWidth, 0);
	}

	/**
	 * Returns the pixel radius of the pivot.
	 * <p>
	 * Default: 5.
	 */
	public Number getRadius() {
		return getAttr(Attrs.radius, 5).asNumber();
	}

	/**
	 * Sets the pixel radius of the pivot.
	 */
	public void setRadius(Number radius) {
		setAttr(Attrs.radius, radius, 5);
	}

}