/* GaugeDialPlotOptions.java

	Purpose:
		
	Description:
		
	History:
		Thu, Jan 16, 2014  3:21:36 PM, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

 */
package org.zkoss.chart.plotOptions;

import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.Optionable;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.Point;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.util.DynamicalAttribute;

/**
 * An option for gauge dial plot for {@link Point#getDial()} and
 * {@link GaugePlotOptions#getDial()} to use.
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author jumperchen
 * @author RaymondChao
 */
public class GaugeDialPlotOptions extends Optionable {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		backgroundColor,
		baseLength,
		baseWidth,
		borderColor,
		borderWidth,
		radius,
		rearLength,
		topWidth
	}

	/**
	 * Returns the background or fill color of the gauge's dial.
	 * <p>
	 * Default: "black".
	 */
	public Color getBackgroundColor() {
		if (!containsKey(Attrs.backgroundColor)) {
			setBackgroundColor("black");
		}
		return (Color) getAttr(Attrs.backgroundColor);
	}

	/**
	 * Sets the background or fill color of the gauge's dial.
	 */
	public void setBackgroundColor(Color color) {
		setAttr(Attrs.backgroundColor, color, NOT_NULL_VALUE);
	}

	/**
	 * Sets the background or fill color of the gauge's dial.
	 */
	public void setBackgroundColor(String color) {
		setBackgroundColor(new Color(color));
	}

	/**
	 * Sets the background or fill color of the gauge's dial.
	 */
	public void setBackgroundColor(LinearGradient color) {
		setBackgroundColor(new Color(color));
	}

	/**
	 * Sets the background or fill color of the gauge's dial.
	 */
	public void setBackgroundColor(RadialGradient color) {
		setBackgroundColor(new Color(color));
	}

	/**
	 * Returns the length of the dial's base part, relative to the total radius
	 * or length of the dial.
	 * <p>
	 * Default: 70%.
	 */
	public String getBaseLength() {
		return getAttr(Attrs.baseLength, "70%").asString();
	}

	/**
	 * Sets the length of the dial's base part, relative to the total radius or
	 * length of the dial.
	 */
	public void setBaseLength(String baseLength) {
		setAttr(Attrs.baseLength, baseLength, "70%");
	}

	/**
	 * Returns the pixel width of the base of the gauge dial. The base is the
	 * part closest to the pivot, defined by baseLength.
	 * <p>
	 * Default: 3.
	 */
	public Number getBaseWidth() {
		return getAttr(Attrs.baseWidth, 3).asNumber();
	}

	/**
	 * Sets the pixel width of the base of the gauge dial. The base is the part
	 * closest to the pivot, defined by baseLength.
	 */
	public void setBaseWidth(Number baseWidth) {
		setAttr(Attrs.baseWidth, baseWidth, 3);
	}

	/**
	 * Returns the border color or stroke of the gauge's dial. By default, the
	 * borderWidth is 0, so this must be set in addition to a custom border
	 * color.
	 * <p>
	 * Default: "silver".
	 */
	public Color getBorderColor() {
		if (!containsKey(Attrs.borderColor)) {
			setBorderColor("silver");
		}
		return (Color) getAttr(Attrs.borderColor);
	}

	/**
	 * Sets the border color or stroke of the gauge's dial. By default, the
	 * borderWidth is 0, so this must be set in addition to a custom border
	 * color.
	 */
	public void setBorderColor(Color color) {
		setAttr(Attrs.borderColor, color, NOT_NULL_VALUE);
	}

	/**
	 * Sets the border color or stroke of the gauge's dial. By default, the
	 * borderWidth is 0, so this must be set in addition to a custom border
	 * color.
	 */
	public void setBorderColor(String color) {
		setBorderColor(new Color(color));
	}

	/**
	 * Sets the border color or stroke of the gauge's dial. By default, the
	 * borderWidth is 0, so this must be set in addition to a custom border
	 * color.
	 */
	public void setBorderColor(LinearGradient color) {
		setBorderColor(new Color(color));
	}

	/**
	 * Sets the border color or stroke of the gauge's dial. By default, the
	 * borderWidth is 0, so this must be set in addition to a custom border
	 * color.
	 */
	public void stBorderColor(RadialGradient color) {
		setBorderColor(new Color(color));
	}

	/**
	 * Returns the width of the gauge dial border in pixels.
	 * <p>
	 * Default: 0.
	 */
	public Number getBorderWidth() {
		return getAttr(Attrs.borderWidth, 0).asNumber();
	}

	/**
	 * Sets the width of the gauge dial border in pixels.
	 */
	public void setBorderWidth(Number borderWidth) {
		setAttr(Attrs.borderWidth, borderWidth, 0);
	}

	/**
	 * Returns the radius or length of the dial, in percentages relative to the
	 * radius of the gauge itself.
	 * <p>
	 * Default: 80%.
	 */
	public String getRadius() {
		return getAttr(Attrs.radius, "80%").asString();
	}

	/**
	 * Sets the radius or length of the dial, in percentages relative to the
	 * radius of the gauge itself.
	 */
	public void setRadius(String radius) {
		setAttr(Attrs.radius, radius, "80%");
	}

	/**
	 * Returns the length of the dial's rear end, the part that extends out on
	 * the other side of the pivot. Relative to the dial's length.
	 * <p>
	 * Default: 10%.
	 */
	public String getRearLength() {
		return getAttr(Attrs.rearLength, "10%").asString();
	}

	/**
	 * Sets the length of the dial's rear end, the part that extends out on the
	 * other side of the pivot. Relative to the dial's length.
	 */
	public void setRearLength(String rearLength) {
		setAttr(Attrs.rearLength, rearLength, "10%");
	}

	/**
	 * Returns the width of the top of the dial, closest to the perimeter. The
	 * pivot narrows in from the base to the top.
	 * <p>
	 * Default: 1.
	 */
	public Number getTopWidth() {
		return getAttr(Attrs.topWidth, 1).asNumber();
	}

	/**
	 * Sets the width of the top of the dial, closest to the perimeter. The
	 * pivot narrows in from the base to the top.
	 */
	public void setTopWidth(Number topWidth) {
		setAttr(Attrs.topWidth, topWidth, 1);
	}

}