/* FunnelPlotOptions.java

	Purpose:
		
	Description:
		
	History:
		Thu, Jan 16, 2014  3:58:30 PM, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

 */
package org.zkoss.chart.plotOptions;

import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.util.DynamicalAttribute;

/**
 * An option for funnel plot
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author jumperchen
 * @author RaymondChao
 */
public class FunnelPlotOptions extends PiePlotOptions {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		height, neckHeight, neckWidth, width,
		// override
		dataLabels
	}


	/**
	 * Returns the option of data labels.
	 */
	public DataLabels getDataLabels() {
		DataLabels dataLabels = (DataLabels) this.getAttr(Attrs.dataLabels);

		if (dataLabels == null) {
			dataLabels = new FunnelDataLabels();
			setDataLabels(dataLabels);
		}
		return dataLabels;
	}
	/**
	 * Returns the height of the neck, the lower part of a funnel. If it is a
	 * number it defines the pixel height, if it is a percentage string it is
	 * the percentage of the plot area height.
	 * <p>
	 * Default: 100%
	 */
	public String getHeight() {
		return getAttr(Attrs.height, "100%").asString();
	}

	/**
	 * Sets the height of the neck, the lower part of a funnel. If it is a
	 * number it defines the pixel height, if it is a percentage string it is
	 * the percentage of the plot area height.
	 */
	public void setHeight(String height) {
		setAttr(Attrs.height, height, "100%");
	}

	/**
	 * Returns the height of the neck, the lower part of the funnel. A number
	 * defines pixel width, a percentage string defines a percentage of the plot
	 * area height.
	 * <p> Default: 25%
	 */
	public String getNeckHeight() {
		return getAttr(Attrs.neckHeight, "25%").asString();
	}

	/**
	 * Sets the height of the neck, the lower part of the funnel. A number
	 * defines pixel width, a percentage string defines a percentage of the plot
	 * area height.
	 */
	public void setNeckHeight(String neckHeight) {
		setAttr(Attrs.neckHeight, neckHeight, "25%");
	}

	/**
	 * Returns the width of the neck, the lower part of the funnel. A number
	 * defines pixel width, a percentage string defines a percentage of the plot
	 * area width.
	 * <p> Default: 30%
	 */
	public String getNeckWidth() {
		return getAttr(Attrs.neckWidth, "30%").asString();
	}

	/**
	 * Sets the width of the neck, the lower part of the funnel. A number
	 * defines pixel width, a percentage string defines a percentage of the plot
	 * area width.
	 */
	public void setNeckWidth(String neckWidth) {
		setAttr(Attrs.neckWidth, neckWidth, "30%");
	}

	/**
	 * Returns the width of the funnel compared to the width of the plot area,
	 * or the pixel width if it is a number.
	 * <p> Default: 90%
	 */
	public String getWidth() {
		return getAttr(Attrs.width, "90%").asString();
	}

	/**
	 * Sets the width of the funnel compared to the width of the plot area, or
	 * the pixel width if it is a number.
	 */
	public void setWidth(String width) {
		setAttr(Attrs.width, width, "90%");
	}

}