/** FunnelDataLabels.java.

	Purpose:
		
	Description:
		
	History:
		5:50:21 PM Mar 6, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
 */
package org.zkoss.chart.plotOptions;

import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.util.DynamicalAttribute;

/**
 * An option of data labels used for Funnel
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author jumperchen
 */
public class FunnelDataLabels extends PieDataLabels {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		// override
		connectorColor
	}

	/**
	 * Sets the color of the line connecting the data label to the pie slice.
	 * <p>
	 * Defaults to <tt>#606060</tt>.
	 */
	public void setConnectorColor(String connectorColor) {
		setAttr(Attrs.connectorColor, connectorColor, "#606060");
	}

	/**
	 * Returns the color of the line connecting the data label to the pie slice.
	 * <p>
	 * Defaults to <tt>#606060</tt>.
	 */
	public String getConnectorColor() {
		return getAttr(Attrs.connectorColor, "#606060").asString();
	}
}
