/* ErrorBarPlotOptions.java

	Purpose:
		
	Description:
		
	History:
		Thu, Jan 16, 2014  3:58:20 PM, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

 */
package org.zkoss.chart.plotOptions;

import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.util.DynamicalAttribute;

/**
 * An option for error bar plot
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author RaymondChao
 */
public class ErrorBarPlotOptions extends BoxPlotOptions {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		color, linkedTo, whiskerWidth
	}
	/**
	 * Returns the main color of the bars. This can be overridden by
	 * {@link #setStemColor(String)} and {@link #setWhiskerColor(String)}
	 * individually.
	 * <p>
	 * Default: "#000000"
	 */
	public Color getColor() {
		if (!containsKey(Attrs.color)) {
			setColor("#000000");
		}
		return (Color) getAttr(Attrs.color);
	}

	/**
	 * Sets the main color of the bars. This can be overridden by
	 * {@link #setStemColor(String)} and {@link #setWhiskerColor(String)}
	 * individually.
	 * <p>
	 * Default: "#000000"
	 */
	public void setColor(Color color) {
		setAttr(Attrs.color, color, NOT_NULL_VALUE);
	}

	/**
	 * Sets the main color of the bars. This can be overridden by
	 * {@link #setStemColor(String)} and {@link #setWhiskerColor(String)}
	 * individually.
	 * <p>
	 * Default: "#000000"
	 */
	public void setColor(String color) {
		setColor(new Color(color));
	}

	/**
	 * Sets the main color of the bars. This can be overridden by
	 * {@link #setStemColor(String)} and {@link #setWhiskerColor(String)}
	 * individually.
	 * <p>
	 * Default: "#000000"
	 */
	public void setColor(LinearGradient color) {
		setColor(new Color(color));
	}

	/**
	 * Sets the main color of the bars. This can be overridden by
	 * {@link #setStemColor(String)} and {@link #setWhiskerColor(String)}
	 * individually.
	 * <p>
	 * Default: "#000000"
	 */
	public void setColor(RadialGradient color) {
		setColor(new Color(color));
	}

	/**
	 * Returns the parent series of the error bar. The default value links it to
	 * the previous series. Otherwise, use the id of the parent series.
	 * <p>
	 * Default: ":previous"
	 */
	public String getLinkedTo() {
		return getAttr(Attrs.linkedTo, ":previous").asString();
	}

	/**
	 * Sets the parent series of the error bar. The default value links it to
	 * the previous series. Otherwise, use the id of the parent series.
	 */
	public void setLinkedTo(String linkedTo) {
		setAttr(Attrs.linkedTo, linkedTo, ":previous");
	}

	/**
	 * Returns the line width of the whiskers, the horizontal lines marking low
	 * and high values. When <code>null</code>, the general
	 * {@link #setLineWidth(Number)} applies.
	 */
	public Number getWhiskerWidth() {
		return getAttr(Attrs.whiskerWidth, null).asNumber();
	}

	/**
	 * Sets the line width of the whiskers, the horizontal lines marking low
	 * and high values. When <code>null</code>, the general
	 * {@link #setLineWidth(Number)} applies.
	 */
	public void setWhiskerWidth(Number whiskerWidth) {
		setAttr(Attrs.whiskerWidth, whiskerWidth);
	}

}