/** BarDataLabels.java.

	Purpose:
		
	Description:
		
	History:
		4:20:02 PM Mar 4, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart.plotOptions;

import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.util.DynamicalAttribute;

/**
 * An option of data labels used for Bar plot
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author jumperchen
 *
 */
public class BarDataLabels extends DataLabels {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		align,
		x
	}

	/**
	 * Returns the alignment of the data label compared to the point. Can be one
	 * of "left", "center" or "right".
	 * <p>
	 * Defaults to <code>"left"</code>.
	 */
	public String getAlign() {
		return getAttr(Attrs.align, "left").asString();
	}

	/**
	 * Sets the alignment of the data label compared to the point. Can be one of
	 * "left", "center" or "right". Defaults to <code>"center"</code>. 'align
	 * the alignment of the data label compared to the point. Can be one of
	 * "left", "center" or "right".
	 * <p>
	 * Defaults to <code>"left"</code>.
	 */
	public void setAlign(String align) {
		if (!("left".equals(align) || "center".equals(align) || "right"
				.equals(align)))
			throw new IllegalArgumentException("Unsupported align: [" + align
					+ "]");
		setAttr(Attrs.align, align, "left");
	}

	/**
	 * Returns the x position offset of the label relative to the point.
	 * <p>
	 * Default: 5
	 */
	public Number getX() {
		return getAttr(Attrs.x, 5).asNumber();
	}

	/**
	 * Sets the x position offset of the label relative to the point.
	 * <p>
	 * Default: 5
	 */
	public void setX(Number x) {
		setAttr(Attrs.x, x, 5);
	}
}
