/* AreaRangePlotOptions.java

	Purpose:
		
	Description:
		
	History:
		Thu, Jan 16, 2014  3:42:07 PM, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

 */
package org.zkoss.chart.plotOptions;

import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.Shadow;
import org.zkoss.chart.util.DynamicalAttribute;

/**
 * An options for area range plot
 * 
 * <p>All the options in this class support
 * {@link DynamicalAttribute}.
 * 
 * @author RaymondChao
 */
public class AreaRangePlotOptions extends AreaPlotOptions {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		lineWidth, shadow, trackByArea, dataLabels
	}

	/**
	 * Returns pixel width of the arearange graph line.
	 * <p>
	 * Default: 1.
	 */
	public Number getLineWidth() {
		return getAttr(Attrs.lineWidth, 1).asNumber();
	}

	/**
	 * Sets pixel width of the arearange graph line.
	 */
	public void setLineWidth(Number lineWidth) {
		setAttr(Attrs.lineWidth, lineWidth, 1);
	}


	/**
	 * Returns whether to apply a drop shadow
	 * <p>
	 * Default: false.
	 * 
	 * @see Shadow
	 */
	public boolean isShadow() {
		return getShadow() != Shadow.NONE;
	}

	/**
	 * Returns whether to apply a drop shadow
	 * <p>
	 * Default: {@link Shadow#NONE}.
	 * 
	 * @see Shadow
	 */
	public Shadow getShadow() {
		return (Shadow) getAttr(Attrs.shadow, Shadow.NONE).asValue();
	}

	/**
	 * Sets whether to apply a drop shadow
	 */
	public void setShadow(boolean shadow) {
		setShadow(shadow ? new Shadow() : Shadow.NONE);
	}

	/**
	 * Sets whether to apply a drop shadow
	 * 
	 * @see Shadow
	 */
	public void setShadow(Shadow shadow) {
		setAttr(Attrs.shadow, shadow);
	}

	/**
	 * Returns whether the whole area or just the line should respond to
	 * mouseover tooltips and other mouse or touch events.
	 * <p>
	 * Default: true.
	 */
	public boolean getTrackByArea() {
		return getAttr(Attrs.trackByArea, true).asBoolean();
	}

	/**
	 * Sets whether the whole area or just the line should respond to mouseover
	 * tooltips and other mouse or touch events.
	 */
	public void setTrackByArea(boolean trackByArea) {
		setAttr(Attrs.trackByArea, trackByArea);
	}


	/**
	 * Returns the option of data labels.
	 */
	public DataLabels getDataLabels() {
		DataLabels dataLabels = (DataLabels) this.getAttr(Attrs.dataLabels);

		if (dataLabels == null) {
			dataLabels = new RangeDataLabels();
			setDataLabels(dataLabels);
		}
		return dataLabels;
	}
}