/* AreaPlotOptions.java

	Purpose:
		
	Description:
		
	History:
		04:35:43 PM Jan 14, 2014, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

 */
package org.zkoss.chart.plotOptions;

import org.zkoss.chart.Color;
import org.zkoss.chart.LinearGradient;
import org.zkoss.chart.PlotAttribute;
import org.zkoss.chart.RadialGradient;
import org.zkoss.chart.util.DynamicalAttribute;

/**
 * An options for area plot
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author RaymondChao
 * @author jumperchen
 */
public class AreaPlotOptions extends SeriesPlotOptions {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		fillColor,
		fillOpacity,
		lineColor,
		negativeFillColor,
		threshold,
		trackByArea
	}

	/**
	 * Returns fill color or gradient for the area. When <code>null</code>, the
	 * series' <code>color</code> is used with the series'
	 * <code>fillOpacity</code>.
	 * <p>
	 * Default: null.
	 */
	public Color getFillColor() {
		return (Color) getAttr(Attrs.fillColor, null).asValue();
	}

	/**
	 * Sets fill color or gradient for the area. When <code>null</code>, the
	 * series' <code>color</code> is used with the series'
	 * <code>fillOpacity</code>.
	 */
	public void setFillColor(Color color) {
		setAttr(Attrs.fillColor, color);
	}

	/**
	 * Sets fill color or gradient for the area. When <code>null</code>, the
	 * series' <code>color</code> is used with the series'
	 * <code>fillOpacity</code>.
	 */
	public void setFillColor(String color) {
		setFillColor(new Color(color));
	}

	/**
	 * Sets fill color or gradient for the area. When <code>null</code>, the
	 * series' <code>color</code> is used with the series'
	 * <code>fillOpacity</code>.
	 */
	public void setFillColor(LinearGradient color) {
		setFillColor(new Color(color));
	}

	/**
	 * Sets fill color or gradient for the area. When <code>null</code>, the
	 * series' <code>color</code> is used with the series'
	 * <code>fillOpacity</code>.
	 */
	public void setFillColor(RadialGradient color) {
		setFillColor(new Color(color));
	}

	/**
	 * Returns fill opacity for the area.
	 * <p>
	 * Default: 0.75.
	 */
	public Number getFillOpacity() {
		return getAttr(Attrs.fillOpacity, 0.75).asNumber();
	}

	/**
	 * Sets fill opacity for the area.
	 */
	public void setFillOpacity(Number fillOpacity) {
		setAttr(Attrs.fillOpacity, fillOpacity, 0.75);
	}

	/**
	 * Returns a separate color for the graph line. By default the line takes
	 * the <code>color</code> of the series, but the lineColor setting allows
	 * setting a separate color for the line without altering the
	 * <code>lineColor</code>.
	 * <p>
	 * Default: null.
	 */
	public Color getLineColor() {
		return (Color) getAttr(Attrs.lineColor, null).asValue();
	}

	/**
	 * Sets a separate color for the graph line. By default the line takes the
	 * <code>color</code> of the series, but the lineColor setting allows
	 * setting a separate color for the line without altering the
	 * <code>fillColor</code>.
	 */
	public void setLineColor(Color color) {
		setAttr(Attrs.lineColor, color);
	}

	/**
	 * Sets a separate color for the graph line. By default the line takes the
	 * <code>color</code> of the series, but the lineColor setting allows
	 * setting a separate color for the line without altering the
	 * <code>fillColor</code>.
	 */
	public void setLineColor(String color) {
		setLineColor(new Color(color));
	}

	/**
	 * Sets a separate color for the graph line. By default the line takes the
	 * <code>color</code> of the series, but the lineColor setting allows
	 * setting a separate color for the line without altering the
	 * <code>fillColor</code>.
	 */
	public void setLineColor(LinearGradient color) {
		setLineColor(new Color(color));
	}

	/**
	 * Sets a separate color for the graph line. By default the line takes the
	 * <code>color</code> of the series, but the lineColor setting allows
	 * setting a separate color for the line without altering the
	 * <code>fillColor</code>.
	 */
	public void setLineColor(RadialGradient color) {
		setLineColor(new Color(color));
	}

	/**
	 * Returns a separate color for the negative part of the area.
	 * <p>
	 * Default: null.
	 */
	public Color getNegativeFillColor() {
		return (Color) getAttr(Attrs.negativeFillColor, null).asValue();
	}

	/**
	 * Sets a separate color for the negative part of the area.
	 */
	public void setNegativeFillColor(Color color) {
		setAttr(Attrs.negativeFillColor, color);
	}

	/**
	 * Sets a separate color for the negative part of the area.
	 */
	public void setNegativeFillColor(String color) {
		setNegativeFillColor(new Color(color));
	}

	/**
	 * Sets a separate color for the negative part of the area.
	 */
	public void setNegativeFillColor(LinearGradient color) {
		setNegativeFillColor(new Color(color));
	}

	/**
	 * Sets a separate color for the negative part of the area.
	 */
	public void setNegativeFillColor(RadialGradient color) {
		setNegativeFillColor(new Color(color));
	}

	/**
	 * Returns whether the whole area or just the line should respond to
	 * mouseover tooltips and other mouse or touch events.
	 * <p>
	 * Default: false.
	 */
	public boolean getTrackByArea() {
		return getAttr(Attrs.trackByArea, false).asBoolean();
	}

	/**
	 * Sets whether the whole area or just the line should respond to mouseover
	 * tooltips and other mouse or touch events.
	 */
	public void setTrackByArea(boolean trackByArea) {
		setAttr(Attrs.trackByArea, trackByArea);
	}

}