/* XYZModel.java

	Purpose:
		
	Description:
		
	History:
		Wed, Mar 19, 2014 11:18:58 AM, Created by jumperchen

Copyright (C)  Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart.model;

import org.zkoss.chart.Charts;

/**
 * A XYZ chart data model.
 *
 * @author jumperchen
 * @see Charts
 */	
public interface XYZModel extends XYModel {

	/**
	 * Get Z value of a specified series and data index.
	 * @param series the series.
	 * @param index the data index.
	 */
	public Number getZ(Comparable<?> series, int index);

	/**
	 * Append an (x,y,z) into a series.
	 * @param series the series.
	 * @param x the x value.
	 * @param y the y value.
	 * @param z the z value.
	 */	
	public void addValue(Comparable<?> series, Number x, Number y, Number z);

	/**
	 * Add an (x,y,z) into a series at the specified index.
	 * @param series the series.
	 * @param x the x value.
	 * @param y the y value.
	 * @param z the z value.
	 * @param index the data index.
	 * @since 5.0.0
	 */	
	public void addValue(Comparable<?> series, Number x, Number y, Number z, int index);

	/**
	 * Replace an (x,y,z) into a series at the specified index.
	 * @param series the series.
	 * @param x the x value.
	 * @param y the y value.
	 * @param z the z value.
	 * @param index the data index.
	 * @since 5.0.0
	 */	
	public void setValue(Comparable<?> series, Number x, Number y, Number z, int index);
}	
