/* SingleValueCategoryModel.java

	Purpose:
		
	Description:
		
	History:
		Wed, Mar 19, 2014 11:18:58 AM, Created by jumperchen

Copyright (C)  Potix Corporation. All Rights Reserved.
*/

package org.zkoss.chart.model;

import java.util.Collection;

import org.zkoss.chart.Charts;

/**
 * A single value category chart data model.
 *
 * @author jumperchen
 * @see Charts
 */
public interface SingleValueCategoryModel extends ChartsModel {
	/**
	 * Get category of the specified index (0 based).
	 * @param index the index of the category.
	 */
	public Comparable<?> getCategory(int index);
		
	/**
	 * Get categories as a collection.
	 */
	public Collection<Comparable<?>> getCategories();
	
	/**
	 * Get value of the specified category.
	 * @param category the pie category.
	 */
	public Number getValue(Comparable<?> category);

	/**
	 * add or update the value of a specified category.
	 * @param category the pie category.
	 * @param value the pie value.
	 */
	public void setValue(Comparable<?> category, Number value);

	/**
	 * remove the value of the specified category.
	 * @param category the pie category.
	 */	
	public void removeValue(Comparable<?> category);
	
	/**
	 * clear the model.
	 */
	public void clear();
}