/* DialModelRange.java

	Purpose:
		
	Description:
		
	History:
		Wed, Mar 19, 2014 11:18:58 AM, Created by jumperchen

Copyright (C)  Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart.model;

/**
 * A data model to be used with dial chart.
 * 
 * @author jumperchen
 */
public interface DialModel extends ChartsModel {

	/**
	 * Returns the number of {@link DialModelScale}s.
	 */
	public abstract int size();

	/**
	 * new an instance of scale in this DialModel.
	 * 
	 * @return an instance of scale in this DialModel.
	 */
	public abstract DialModelScale newScale();

	/**
	 * new an instance of scale in this DialModel.
	 * 
	 * @param lowerBound
	 *            lower bound of this scale.
	 * @param upperBound
	 *            upper bound of this scale.
	 * @param startAngle
	 *            starting angle in degree associated to the sclae's lower
	 *            bound(0 degree point to east, counter-clockwise is positive).
	 * @param extent
	 *            angles in degree extended from the starting angle (counter
	 *            clockwise is positive).
	 * @param majorTickInterval
	 *            the interval between major tick (in lower bound and upper
	 *            bound).
	 * @param minorTickCount
	 *            the number of minor ticks between major tick.
	 */
	public abstract DialModelScale newScale(double lowerBound,
			double upperBound, double startAngle, double extent,
			double majorTickInterval, int minorTickCount);

	/**
	 * Return the index of the specified model entry.
	 * 
	 * @param entry
	 *            the DialModelScale
	 * @return the index of the specified model entry.
	 */
	public abstract int indexOf(DialModelScale entry);

	/**
	 * Returns the {@link DialModelScale} of the specified index.
	 * 
	 * @param index
	 *            the index of the entry.
	 * @return the DialModelScale.
	 */
	public abstract DialModelScale getScale(int index);

	/**
	 * Remove the specified DialModelScale from this DialModel.
	 * 
	 * @param scale
	 */
	public abstract void removeScale(DialModelScale scale);

	/**
	 * Get value of the scale per the specified index.
	 * 
	 * @param index
	 *            the scale index.
	 */
	public abstract double getValue(int index);

	/**
	 * add or update the value of a specified scale index.
	 * 
	 * @param index
	 *            the index of the Scale
	 * @param value
	 *            the value
	 */
	public abstract void setValue(int index, double value);

	/**
	 * clear the model.
	 */
	public abstract void clear();

	/**
	 * Set the background alpha of the dial frame (transparency, 0 ~ 255).
	 * 
	 * @param alpha
	 *            the transparency of background color (0 ~ 255, default to 255
	 *            opaque).
	 */
	public abstract void setFrameBgAlpha(int alpha);

	/**
	 * Get the background alpha of the dial frame (transparency, 0 ~ 255,
	 * opacue).
	 */
	public abstract int getFrameBgAlpha();

	/**
	 * Set the background color of the dial frame.
	 * 
	 * @param color
	 *            in #RRGGBB format (hexadecimal).
	 */
	public abstract void setFrameBgColor(String color);

	/**
	 * Get the background color of the dial frame (in string as #RRGGBB). null
	 * means default.
	 */
	public abstract String getFrameBgColor();

	/**
	 * Get the background color of the dial frame in int array (0: red, 1:
	 * green, 2:blue). null means default.
	 */
	public abstract int[] getFrameBgRGB();

	/**
	 * Set the foreground color of the dial frame.
	 * 
	 * @param color
	 *            in #RRGGBB format (hexadecimal).
	 */
	public abstract void setFrameFgColor(String color);

	/**
	 * Get the foreground color of the dial frame (in string as #RRGGBB). null
	 * means default.
	 */
	public abstract String getFrameFgColor();

	/**
	 * Get the foreground color of the dial frame in int array (0: red, 1:
	 * green, 2:blue). null means default.
	 */
	public abstract int[] getFrameFgRGB();

	/**
	 * Set the 1st background color of the dial frame (for gradient starting
	 * color).
	 * 
	 * @param color
	 *            in #RRGGBB format (hexadecimal).
	 */
	public abstract void setFrameBgColor1(String color);

	/**
	 * Get the 1st background color of the dial frame (in string as #RRGGBB) for
	 * gradient starting color. null means use default.
	 */
	public abstract String getFrameBgColor1();

	/**
	 * Get the 1st background color of the dial frame in int array (0: red, 1:
	 * green, 2:blue) for gradient starting color. null means use default.
	 */
	public abstract int[] getFrameBgRGB1();

	/**
	 * Set the 2nd background color of the dial frame (for gradient ending
	 * color).
	 * 
	 * @param color
	 *            in #RRGGBB format (hexadecimal).
	 */
	public abstract void setFrameBgColor2(String color);

	/**
	 * Get the 2nd background color of the dial frame (in string as #RRGGBB) for
	 * gradient ending color. null means default.
	 */
	public abstract String getFrameBgColor2();

	/**
	 * Get the 2nd background color of the dial frame in int array (0: red, 1:
	 * green, 2:blue) for gradient ending color. null means default.
	 */
	public abstract int[] getFrameBgRGB2();

	/**
	 * Set the Frame background gradient color direction (from bgColor1 to
	 * bgColor2); center_horizontal, center_vertical, horizontal, vertical.
	 */
	public abstract void setGradientDirection(String direction);

	/**
	 * Returns the Frame background gradient color direction (from bgColor1 to
	 * bgColor2); center_horizontal, center_vertical, horizontal, vertical.
	 */
	public abstract String getGradientDirection();

	/**
	 * Sets the radius percentage(0 ~ 1) of the meter's cap; default to 0.07.
	 * 
	 * @param radius
	 *            the radius percentage(0 ~ 1) of the meter's cap.
	 */
	public abstract void setCapRadius(double radius);

	/**
	 * Return the radius percentage(0 ~ 1) of the meter's cap; default to 0.07.
	 * 
	 * @return the radius percentage(0 ~ 1) of the meter's cap.
	 */
	public abstract double getCapRadius();

}