/* DefaultXYZModel.java

	Purpose:
		
	Description:
		
	History:
		Mar 19 15:52:25     2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

*/
package org.zkoss.chart.model;

import java.util.ArrayList;
import java.util.List;

import org.zkoss.chart.Charts;
import org.zkoss.zul.event.ChartDataEvent;

/**
 * A XYZ data model implementation of {@link XYZModel}.
 * A XYZ model is an N series of (X, Y, Z) data objects .
 *
 * @author jumperchen
 * @see XYModel
 * @see Charts
 */
public class DefaultXYZModel extends DefaultXYModel implements XYZModel {
	private static final long serialVersionUID = 20140319155001L;

	//-- XYModel --//
	/** Not supported since we need not only x, y, but also z information.
	 */
	public void addValue(Comparable<?> series, Number x, Number y) {
		throw new UnsupportedOperationException("Use addValue(series, x, y, z) instead!");
	}
	/** Not supported since we need not only x, y, but also z information.
	 */
	public void addValue(Comparable<?> series, Number x, Number y, int index) {
		throw new UnsupportedOperationException("Use addValue(series, x, y, z, index) instead!");
	}
	/** Not supported since we need not only x, y, but also z information.
	 */
	public void setValue(Comparable<?> series, Number x, Number y, int index) {
		throw new UnsupportedOperationException("Use setValue(series, x, y, z, index) instead!");
	}
	
	//-- XYZModel --//
	public Number getZ(Comparable<?> series, int index) {
		final List<XYPair> xyzTuples = _seriesMap.get(series);
		
		if (xyzTuples != null) {
			return ((XYZTuple)xyzTuples.get(index)).getZ();
		}
		return null;
	}

	public void addValue(Comparable<?> series, Number x, Number y, Number z) {
		addValue(series, x, y, z, -1);
	}
	
	public void setValue(Comparable<?> series, Number x, Number y, Number z, int index) {
		removeValue0(series, index);
		int cIndex = addValue0(series, x, y, z, index);
		fireEvent(ChartDataEvent.CHANGED, series, (Comparable<?>) x, _seriesList.indexOf(series), cIndex, _seriesMap.get(series).get(cIndex).toNumbers());
	}
	
	public void addValue(Comparable<?> series, Number x, Number y, Number z, int index) {
		int cIndex = addValue0(series, x, y, z, index);
		fireEvent(ChartDataEvent.ADDED, series, (Comparable<?>) x, _seriesList.indexOf(series), cIndex, _seriesMap.get(series).get(cIndex).toNumbers());
	}
	
	private int addValue0(Comparable<?> series, Number x, Number y, Number z, int index) {
		List<XYPair> xyzTuples = _seriesMap.get(series);
		if (xyzTuples == null) {
			xyzTuples = new ArrayList<XYPair>();
			_seriesMap.put(series, xyzTuples);
			_seriesList.add(series);
		}
		int cIndex = index;
		if (index >= 0)
			xyzTuples.add(index, new XYZTuple(x, y, z));
		else {
			cIndex = xyzTuples.size();
			xyzTuples.add(new XYZTuple(x, y, z));
		}
		return cIndex;
	}

	public void removeValue(Comparable<?> series, int index) {
		XYZTuple xyz = removeValue0(series, index);
		if (xyz != null)
			fireEvent(ChartDataEvent.REMOVED, series, (Comparable<?>)xyz.getX(), _seriesList.indexOf(series), index, xyz.toNumbers());
		else
			fireEvent(ChartDataEvent.REMOVED, series, null, _seriesList.indexOf(series), -1, null);
	}
	
	private XYZTuple removeValue0(Comparable<?> series, int index) {
		List<XYPair> xyzTuples = _seriesMap.get(series);
		if (xyzTuples == null) {
			return null;
		}
		return (XYZTuple) xyzTuples.remove(index);
	}
	
	//-- internal class --//
	private static class XYZTuple extends XYPair {
		private static final long serialVersionUID = 20091008183759L;
		private Number _z;
		
		private XYZTuple(Number x, Number y, Number z) {
			super(x, y);
			_z = z;
		}
		
		public Number getZ() {
			return _z;
		}
		
		public Number[] toNumbers() {
			return new Number[] {getX(), getY(), _z};
		}
	}
}
