/* DefaultSingleValueCategoryModel.java

	Purpose:
		
	Description:
		
	History:
		Mar 19 15:46:14     2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.zkoss.chart.Charts;
import org.zkoss.lang.Objects;
import org.zkoss.zul.event.ChartDataEvent;

/**
 * A Pie chart data model implementation of {@link SingleValueCategoryModel}.
 * SimpleSingleValueCategoryModel used by PieChart and FunnelChart is a series of (Category, singleValue) data objects.
 *
 * @author jumperchen
 * @see SingleValueCategoryModel
 * @see Charts
 */
public class DefaultSingleValueCategoryModel extends AbstractChartsModel implements SingleValueCategoryModel {
	private static final long serialVersionUID = 20140319154808L;
	private List<Comparable<?>> _categoryList = new ArrayList<Comparable<?>>();
	private Map<Comparable<?>, Number> _categoryMap = new HashMap<Comparable<?>, Number>();
	
	//-- SingleValueCategoryModel --//
	public Comparable<?> getCategory(int index) {
		return _categoryList.get(index);
	}

	public Collection<Comparable<?>> getCategories() {
		return _categoryList;
	}
	
	public Number getValue(Comparable<?> category) {
		return _categoryMap.get(category);
	}

	public void setValue(Comparable<?> category, Number value) {
		if (!_categoryMap.containsKey(category)) {
			final int cIndex = _categoryList.size();
			_categoryList.add(category);
			_categoryMap.put(category, value);
			fireEvent(ChartDataEvent.ADDED, null, category, 0, cIndex, value);
		} else {
			Number ovalue = _categoryMap.get(category);
			if (Objects.equals(ovalue, value)) {
				return;
			}
			final int cIndex = _categoryList.indexOf(category);
			_categoryMap.put(category, value);
			fireEvent(ChartDataEvent.CHANGED, null, category, 0, cIndex, value);
		}
	}
	
	public void removeValue(Comparable<?> category) {
		_categoryMap.remove(category);

		final int cIndex = _categoryList.indexOf(category);
		
		Comparable<?> value = _categoryList.remove(category);
		fireEvent(ChartDataEvent.REMOVED, null, category, 0, cIndex, value);
	}
	
	public void clear() {
		_categoryMap.clear();
		_categoryList.clear();
		fireEvent(ChartDataEvent.REMOVED, null, null, -1, -1, null);
	}

	
	public Object clone() {
		DefaultSingleValueCategoryModel clone = (DefaultSingleValueCategoryModel) super.clone();
		if (_categoryList != null)
			clone._categoryList = new ArrayList<Comparable<?>>(_categoryList);
		if (_categoryMap != null)
			clone._categoryMap = new HashMap<Comparable<?>, Number>(_categoryMap);
		return clone;
	}
}

