/* DefaultDialModel.java

	Purpose:
		
	Description:
		
	History:
		Wed, Mar 19, 2014 11:18:58 AM, Created by jumperchen

Copyright (C)  Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart.model;

import java.util.ArrayList;
import java.util.List;

import org.zkoss.lang.Objects;
import org.zkoss.util.ArraysX;
import org.zkoss.zk.ui.UiException;

/**
 * A data model to be used with dial chart.
 * @author jumperchen
 *
 */
public class DefaultDialModel extends AbstractChartsModel implements DialModel {
	private static final long serialVersionUID = 20091008183229L;

	private List<DialModelScale> _series = new ArrayList<DialModelScale>(4);
	
	//DialFrame background
	private String _bgColor = "#FFFFFF";
	private int[] _bgRGB = new int[] {0xFF,0xFF,0xFF}; //background red, green, blue (0 ~ 255, 0 ~ 255, 0 ~ 255)
	private int _bgAlpha = 255; //background alpha transparency (0 ~ 255, default to 255)
	private String _bgColor1 = "#FFFFFF";
	private int[] _bgRGB1 = new int[] {0xFF,0xFF,0xFF}; //background red, green, blue (0 ~ 255, 0 ~ 255, 0 ~ 255) for gradient background starting color
	private String _bgColor2 = "#AAAADC";
	private int[] _bgRGB2 = new int[] {0xAA,0xAA,0xDC}; //background red, green, blue (0 ~ 255, 0 ~ 255, 0 ~ 255) for gradient background ending color
	
	//DialFrame foreground
	private String _fgColor;
	private int[] _fgRGB = new int[] {0x80,0x80,0x80}; //background red, green, blue (0 ~ 255, 0 ~ 255, 0 ~ 255)
	
	//DialBackground gradient direction
	private String _gdirection = "vertical";
	
	//DialCap radius
	private double _capRadius = 0.07;
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#size()
	 */
	public int size() {
		return _series.size();
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#newScale()
	 */
	public DialModelScale newScale() {
		final DialModelScale entry = new DialModelScale(this);
		_series.add(entry);
		fireEvent(ChartsDataEvent.ADDED, DialChartsDataEvent.SCALE, entry);
		return entry;
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#newScale(double, double, double, double, double, int)
	 */
	public DialModelScale newScale(double lowerBound, double upperBound, 
		double startAngle, double extent, double majorTickInterval, int minorTickCount) {
		final DialModelScale entry = new DialModelScale(this);
		_series.add(entry);
		entry.setScale(lowerBound, upperBound, startAngle, extent, majorTickInterval, minorTickCount);
		fireEvent(ChartsDataEvent.ADDED, DialChartsDataEvent.SCALE, entry);
		return entry;
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#indexOf(org.zkoss.chart.model.DialModelScale)
	 */
	public int indexOf(DialModelScale entry) {
		return _series.indexOf(entry);
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#getScale(int)
	 */
	public DialModelScale getScale(int index) {
		return _series.get(index);
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#removeScale(org.zkoss.chart.model.DialModelScale)
	 */
	public void removeScale(DialModelScale scale) {
		int index = _series.indexOf(scale);
		_series.remove(scale);
		fireEvent(ChartsDataEvent.REMOVED, DialChartsDataEvent.SCALE, index);
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#getValue(int)
	 */
	public double getValue(int index) {
		return getScale(index).getValue();
	}

	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#setValue(int, double)
	 */
	public void setValue(int index,  double value) {
		getScale(index).setValue(value);
	}

	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#clear()
	 */
	public void clear() {
		if (!_series.isEmpty()) {
			_series.clear();
			fireEvent(ChartsDataEvent.REMOVED, DialChartsDataEvent.SCALE, -1); // -1 means all
		}
	}

	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#setFrameBgAlpha(int)
	 */
	public void setFrameBgAlpha(int alpha) {
		if (alpha == _bgAlpha) {
			return;
		}
		if (alpha > 255 || alpha < 0) {
			alpha = 255;
		}
		_bgAlpha = alpha;
		fireEvent(ChartsDataEvent.CHANGED, DialChartsDataEvent.FRAME_BG_ALPHA, alpha);
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#getFrameBgAlpha()
	 */
	public int getFrameBgAlpha() {
		return _bgAlpha;
	}

	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#setFrameBgColor(java.lang.String)
	 */
	public void setFrameBgColor(String color) {
		if (Objects.equals(color, _bgColor)) {
			return;
		}
		_bgColor = color;
		if (_bgColor == null) {
			_bgRGB = null;
		} else {
			_bgRGB = new int[3];
			decode(_bgColor, _bgRGB);
		}
		fireEvent(ChartsDataEvent.CHANGED, DialChartsDataEvent.FRAME_BG_COLOR, color);
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#getFrameBgColor()
	 */
	public String getFrameBgColor() {
		return _bgColor;
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#getFrameBgRGB()
	 */
	public int[] getFrameBgRGB() {
		return _bgRGB;
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#setFrameFgColor(java.lang.String)
	 */
	public void setFrameFgColor(String color) {
		if (Objects.equals(color, _fgColor)) {
			return;
		}
		_fgColor = color;
		if (_fgColor == null) {
			_fgRGB = null;
		} else {
			_fgRGB = new int[3];
			decode(_fgColor, _fgRGB);
		}
		fireEvent(ChartsDataEvent.CHANGED, DialChartsDataEvent.FRAME_FG_COLOR, color);
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#getFrameFgColor()
	 */
	public String getFrameFgColor() {
		return _fgColor;
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#getFrameFgRGB()
	 */
	public int[] getFrameFgRGB() {
		return _fgRGB;
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#setFrameBgColor1(java.lang.String)
	 */
	public void setFrameBgColor1(String color) {
		if (Objects.equals(color, _bgColor1)) {
			return;
		}
		_bgColor1 = color;
		if (_bgColor1 == null) {
			_bgRGB1 = null;
		} else {
			_bgRGB1 = new int[3];
			decode(_bgColor1, _bgRGB1);
		}
		fireEvent(ChartsDataEvent.CHANGED, DialChartsDataEvent.FRAME_BG_COLOR_1, color);
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#getFrameBgColor1()
	 */
	public String getFrameBgColor1() {
		return _bgColor1;
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#getFrameBgRGB1()
	 */
	public int[] getFrameBgRGB1() {
		return _bgRGB1;
	}

	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#setFrameBgColor2(java.lang.String)
	 */
	public void setFrameBgColor2(String color) {
		if (Objects.equals(color, _bgColor2)) {
			return;
		}
		_bgColor2 = color;
		if (_bgColor2 == null) {
			_bgRGB2 = null;
		} else {
			_bgRGB2 = new int[3];
			decode(_bgColor2, _bgRGB2);
		}
		fireEvent(ChartsDataEvent.CHANGED, DialChartsDataEvent.FRAME_BG_COLOR_2, color);
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#getFrameBgColor2()
	 */
	public String getFrameBgColor2() {
		return _bgColor2;
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#getFrameBgRGB2()
	 */
	public int[] getFrameBgRGB2() {
		return _bgRGB2;
	}

	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#setGradientDirection(java.lang.String)
	 */
	public void setGradientDirection(String direction) {
		_gdirection = direction;
		fireEvent(ChartsDataEvent.CHANGED, DialChartsDataEvent.GRADIENT_DIRECTION, direction); //ZK-1693
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#getGradientDirection()
	 */
	public String getGradientDirection() {
		return _gdirection;
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#setCapRadius(double)
	 */
	public void setCapRadius(double radius) {
		_capRadius = radius;
		fireEvent(ChartsDataEvent.CHANGED, DialChartsDataEvent.CAP_RADIUS, radius);
	}
	
	/* (non-Javadoc)
	 * @see org.zkoss.chart.model.DialModel#getCapRadius()
	 */
	public double getCapRadius() {
		return _capRadius;
	}

	/**
	 * Fire the chart data event with the given property key.
	 * @param type
	 * @param propertyKey
	 * @param data
	 */
	protected void fireEvent(int type, String propertyKey, Object data) {
		final ChartsDataEvent evt = new DialChartsDataEventImpl(this, type, propertyKey, data);
		for (ChartsDataListener l: _listeners)
			l.onChange(evt);
	}
	/**package*/ static void decode(String color, int[] rgb) {
		if (color == null) {
			return;
		}
		if (color.length() != 7 || color.charAt(0) != '#') {
			throw new UiException("Incorrect color format (#RRGGBB) : "+color);
		}
		rgb[0] = Integer.parseInt(color.substring(1, 3), 16);
		rgb[1] = Integer.parseInt(color.substring(3, 5), 16);
		rgb[2] = Integer.parseInt(color.substring(5, 7), 16);
	}

	public Object clone() {
		DefaultDialModel clone = (DefaultDialModel) super.clone();
		if (_bgRGB != null)
			clone._bgRGB = (int[]) ArraysX.duplicate(_bgRGB);
		if (_bgRGB1 != null)
			clone._bgRGB1 = (int[]) ArraysX.duplicate(_bgRGB1);
		if (_bgRGB2 != null)
			clone._bgRGB2 = (int[]) ArraysX.duplicate(_bgRGB2);
		if (_fgRGB != null)
			clone._fgRGB = (int[]) ArraysX.duplicate(_fgRGB);
		return clone;
	}
}
