/** ChartsModelProxy.java.

	Purpose:
		
	Description:
		
	History:
		5:03:56 PM Mar 20, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
 */
package org.zkoss.chart.model;

import java.util.Collection;
import java.util.List;

import org.zkoss.zul.ChartModel;
import org.zkoss.zul.event.ChartDataEvent;
import org.zkoss.zul.event.ChartDataListener;

/**
 * A helper class to convert {@link ChartModel} into {@link ChartsModel}
 * <p>This function can only support for ZK 7.0.1+ version.
 * @author jumperchen
 */
abstract public class ChartsModelProxy extends AbstractChartsModel {

	private ChartModel _model;

	public ChartsModelProxy(ChartModel model) {
		_model = model;
		_model.addChartDataListener(new SmartChartDataListener(this));
	}

	protected ChartModel getModel() {
		return _model;
	}

	/**
	 * Returns the instance of ChartsModel which converts from ChartModel
	 */
	public static ChartsModel getInstance(ChartModel model) {
		if (model instanceof org.zkoss.zul.CategoryModel) {
			return new CategoryModelProxy(model);
		} else if (model instanceof org.zkoss.zul.PieModel) {
			return new PieModelProxy(model);
		} else if (model instanceof org.zkoss.zul.SingleValueCategoryModel) {
			return new SingleValueCategoryModelProxy(model);
		} else if (model instanceof org.zkoss.zul.XYZModel) {
			return new XYZModelProxy(model);
		} else if (model instanceof org.zkoss.zul.XYModel) {
			return new XYModelProxy(model);
		} else {
			throw new IllegalArgumentException("Unsupported ChartModel: ["
					+ model + "], please use the model in org.zkoss.chart.model package instead.");
		}
	}

	public void fireEvent(ChartsDataEvent evt) {
		for (ChartsDataListener l : _listeners)
			l.onChange(evt);
	}

	private static class PieModelProxy extends SingleValueCategoryModelProxy
			implements PieModel {

		public PieModelProxy(ChartModel model) {
			super(model);
		}
	};

	private static class SingleValueCategoryModelProxy extends ChartsModelProxy
			implements SingleValueCategoryModel {

		public SingleValueCategoryModelProxy(ChartModel model) {
			super(model);
		}

		protected org.zkoss.zul.SingleValueCategoryModel getModel() {
			return (org.zkoss.zul.SingleValueCategoryModel) super.getModel();
		}

		public Comparable<?> getCategory(int index) {
			return getModel().getCategory(index);
		}

		public Collection<Comparable<?>> getCategories() {
			return getModel().getCategories();
		}

		public Number getValue(Comparable<?> category) {
			return getModel().getValue(category);
		}

		public void setValue(Comparable<?> category, Number value) {
			getModel().setValue(category, value);
		}

		public void removeValue(Comparable<?> category) {
			getModel().removeValue(category);
		}

		public void clear() {
			getModel().clear();
		}
	};

	private static class CategoryModelProxy extends ChartsModelProxy implements
			CategoryModel {

		public CategoryModelProxy(ChartModel model) {
			super(model);
		}

		protected org.zkoss.zul.CategoryModel getModel() {
			return (org.zkoss.zul.CategoryModel) super.getModel();
		}

		public Comparable<?> getSeries(int index) {
			return getModel().getSeries(index);
		}

		public Comparable<?> getCategory(int index) {
			return getModel().getCategory(index);
		}

		public Collection<Comparable<?>> getSeries() {
			return getModel().getSeries();
		}

		public Collection<Comparable<?>> getCategories() {
			return getModel().getCategories();
		}

		public Collection<List<Comparable<?>>> getKeys() {
			return getModel().getKeys();
		}

		public Number getValue(Comparable<?> series, Comparable<?> category) {
			return getModel().getValue(series, category);
		}

		public void setValue(Comparable<?> series, Comparable<?> category,
				Number value) {
			getModel().setValue(series, category, value);
		}

		public void removeValue(Comparable<?> series, Comparable<?> category) {
			getModel().removeValue(series, category);
		}

		public void clear() {
			getModel().clear();
		}
	};

	private static class XYModelProxy extends ChartsModelProxy implements
			XYModel {

		public XYModelProxy(ChartModel model) {
			super(model);
		}

		protected org.zkoss.zul.XYModel getModel() {
			return (org.zkoss.zul.XYModel) super.getModel();
		}

		public Comparable<?> getSeries(int index) {
			return getModel().getSeries(index);
		}

		public Collection<Comparable<?>> getSeries() {
			return getModel().getSeries();
		}

		public int getDataCount(Comparable<?> series) {
			return getModel().getDataCount(series);
		}

		public Number getX(Comparable<?> series, int index) {
			return getModel().getX(series, index);
		}

		public Number getY(Comparable<?> series, int index) {
			return getModel().getY(series, index);
		}

		public void setValue(Comparable<?> series, Number x, Number y, int index) {
			getModel().setValue(series, x, y, index);
		}

		public void addValue(Comparable<?> series, Number x, Number y) {
			getModel().addValue(series, x, y);
		}

		public void addValue(Comparable<?> series, Number x, Number y, int index) {
			getModel().addValue(series, x, y, index);
		}

		public void setAutoSort(boolean auto) {
			getModel().setAutoSort(auto);
		}

		public boolean isAutoSort() {
			return getModel().isAutoSort();
		}

		public void removeSeries(Comparable<?> series) {
			getModel().removeSeries(series);
		}

		public void removeValue(Comparable<?> series, int index) {
			getModel().removeValue(series, index);
		}

		public void clear() {
			getModel().clear();
		}

	};

	private static class XYZModelProxy extends XYModelProxy implements
			XYZModel {

		public XYZModelProxy(ChartModel model) {
			super(model);
		}
		
		protected org.zkoss.zul.XYZModel getModel() {
			return (org.zkoss.zul.XYZModel) super.getModel();
		}

		public Number getZ(Comparable<?> series, int index) {
			return getModel().getZ(series, index);
		}

		public void addValue(Comparable<?> series, Number x, Number y, Number z) {
			getModel().addValue(series, x, y, z);
		}

		public void addValue(Comparable<?> series, Number x, Number y,
				Number z, int index) {
			getModel().addValue(series, x, y, z, index);
		}

		public void setValue(Comparable<?> series, Number x, Number y,
				Number z, int index) {
			getModel().setValue(series, x, y, z, index);
		}
	};
	
	private static class SmartChartDataListener implements ChartDataListener {
		private ChartsModelProxy _model;

		public SmartChartDataListener(ChartsModelProxy model) {
			_model = model;
		}

		public void onChange(ChartDataEvent event) {
			_model.fireEvent(new ChartsDataEventImpl(_model, event.getType(),
					event.getSeries(), event.getCategory(), event
							.getSeriesIndex(), event.getCategoryIndex(), event
							.getData()));
		}
	}
}
