/* ChartsModel.java

	Purpose:
		
	Description:
		
	History:
		Wed, Mar 19, 2014 11:18:58 AM, Created by jumperchen

Copyright (C)  Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart.model;

import org.zkoss.chart.Charts;

/**
 * Charts Model is used to hold the data model for the charts component.
 * <ul>
 * <li>{@link PieModel}: one series of data objects. Each data object contains the category name and numeric value of a pie.</li>
 * <li>{@link CategoryModel}: n series of data objects. Each data object contains the category name and associated numeric value .</li>
 * <li>{@link XYModel}: n series of data objects. Each data object contains an (x,y) pair.</li>
 * <li>{@link XYZModel}: n series of data objects. Each data object contains an (x,y,z) pair; since 3.5.0</li>
 * </ul>
 *
 * This interface defines the data model for components like {@link Charts}
 * use to get the value of data.
 *
 * @author jumperchen
 * @see Charts
 * @see PieModel
 * @see SingleValueCategoryModel
 * @see CategoryModel
 * @see XYModel
 * @see XYZModel
 */
public interface ChartsModel {
	/** Adds a listener to the chart that's notified each time a change
	 * to the data model occurs. 
	 */
	public void addChartsDataListener(ChartsDataListener l);
    /** Removes a listener from the chart that's notified each time
     * a change to the data model occurs. 
     */
	public void removeChartsDataListener(ChartsDataListener l) ;
}
