/* ChartsDataEventImpl.java

	Purpose:
		
	Description:
		
	History:
		Wed, Mar 19, 2014 11:18:58 AM, Created by jumperchen

Copyright (C)  Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart.model;

/**
 * Defines an event that encapsulates changes to a charts' data model. 
 *
 * @author jumperchen
 */
public class ChartsDataEventImpl implements ChartsDataEvent {
	/** Identifies one or more changes in the charts contents. */
	private final ChartsModel _model;
	private final int _type;
	private final Comparable _series;
	private final Comparable _category;
	private final Object _data;
	private int _sIndex = -1;
	private int _cIndex = -1;

	public ChartsDataEventImpl(ChartsModel model, int type, Comparable series, Comparable category, int seriesIndex, int categoryIndex, Object data) {
		if (model == null)
			throw new NullPointerException();
		_model = model;
		_type = type;
		_series = series;
		_data = data;
		_sIndex = seriesIndex;
		_cIndex = categoryIndex;
		_category = category;
	}
	
	public int getSeriesIndex() {
		return _sIndex;
	}
	
	public int getCategoryIndex() {
		return _cIndex;
	}
	
	public Comparable getCategory() {
		return _category;
	}
	
	public ChartsModel getModel() {
		return _model;
	}
	
	public int getType() {
		return _type;
	}
	
	public Comparable getSeries() {
		return _series;
	}
	
	public Object getData() {
		return _data;
	}
}
