/* ChartsDataEvent.java

	Purpose:
		
	Description:
		
	History:
		Wed, Mar 19, 2014 11:18:58 AM, Created by jumperchen

Copyright (C)  Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart.model;

import org.zkoss.chart.Charts;

/**
 * A inferface of charts data event
 * @author jumperchen
 * @see Charts
 */
public interface ChartsDataEvent {

	/** Identifies one or more changes in the lists contents. */
	public static final int CHANGED = 0;
	/** Identifies the addition of one or more contiguous items to the list. */
	public static final int ADDED = 1;
	/** Identifies the removal of one or more contiguous items from the list. */
	public static final int REMOVED = 2;

	/**
	 * Returns the series index, if any.
	 */
	public abstract int getSeriesIndex();

	/**
	 * Returns the category index, if any.
	 */
	public abstract int getCategoryIndex();

	/** Returns the category of the chart data model.
	 */
	public abstract Comparable getCategory();

	/** Returns the chart model that fires this event.
	 */
	public abstract ChartsModel getModel();

	/** Returns the event type: CHANGED, ADDED, REMOVED.
	 */
	public abstract int getType();

	/** Returns the series of the chart data model.
	 */
	public abstract Comparable getSeries();

	/** Returns customer data. Depends on the implementation.
	 */
	public abstract Object getData();

}