/* CategoryModel.java

	Purpose:
		
	Description:
		
	History:
		Wed, Mar 19, 2014 11:18:58 AM, Created by jumperchen

Copyright (C)  Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart.model;

import java.util.Collection;
import java.util.List;

import org.zkoss.chart.Charts;

/**
 * A category chart data model.
 *
 * @author jumperchen
 * @see Charts
 */
public interface CategoryModel extends ChartsModel {
	/**
	 * Get a series of the specified index;
	 */
	public Comparable<?> getSeries(int index);
	
	/**
	 * Get a category of the specified index;
	 */
	public Comparable<?> getCategory(int index);

	/**
	 * Get all series as a collection.
	 */
	public Collection<Comparable<?>> getSeries();

	/**
	 * Get categories of a specified series as a collection.
	 */
	public Collection<Comparable<?>> getCategories();

	/**
	 * Get (series, category) pairs of this chart data model. The returned 
	 * value is a collection of List where list.get(0) is the 
	 * series, list.get(1) is the category, in the order the {@link #setValue} is 
	 * called.
	 */
	public Collection<List<Comparable<?>>> getKeys();
	
	/**
	 * Get value of the specified series and category.
	 * @param series the series
	 * @param category the category.
	 */
	public Number getValue(Comparable<?> series, Comparable<?> category);

	/**
	 * add or update the value of a specified series and category.
	 * @param series the series
	 * @param category the category.
	 * @param value the value
	 */
	public void setValue(Comparable<?> series, Comparable<?> category, Number value);

	/**
	 * remove the value of the specified series and category.
	 * @param series the series
	 * @param category the category.
	 */	
	public void removeValue(Comparable<?> series, Comparable<?> category);
	
	/**
	 * clear the model.
	 */
	public void clear();
}