/* AbstractChartsModel.java

	Purpose:
		
	Description:
		
	History:
		Wed, Mar 19, 2014 11:18:58 AM, Created by jumperchen

Copyright (C)  Potix Corporation. All Rights Reserved.
 */
package org.zkoss.chart.model;

import java.util.List;
import java.util.LinkedList;

import org.zkoss.io.Serializables;

/**
 * A skeletal implementation for {@link ChartsModel}.
 * 
 * @author jumperchen
 */
abstract public class AbstractChartsModel implements ChartsModel,
		java.io.Serializable {
	private static final long serialVersionUID = 20140319115913L;
	protected List<ChartsDataListener> _listeners = new LinkedList<ChartsDataListener>();

	/**
	 * Fires a {@link ChartsDataEvent} for all registered listener (thru
	 * {@link #addChartsDataListener}.
	 * <p>
	 * Note: you can invoke this method only in an event listener.
	 */
	protected void fireEvent(int type, Comparable<?> series,
			Comparable<?> category, int seriesIndex, int categoryIndex,
			Object data) {
		final ChartsDataEvent evt = new ChartsDataEventImpl(this, type, series,
				category, seriesIndex, categoryIndex, data);
		for (ChartsDataListener l : _listeners)
			l.onChange(evt);
	}

	// -- ChartsModel --//
	public void addChartsDataListener(ChartsDataListener l) {
		if (l == null)
			throw new NullPointerException();
		_listeners.add(l);
	}

	public void removeChartsDataListener(ChartsDataListener l) {
		_listeners.remove(l);
	}

	// Serializable//
	private synchronized void writeObject(java.io.ObjectOutputStream s)
			throws java.io.IOException {
		s.defaultWriteObject();

		Serializables.smartWrite(s, _listeners);
	}

	private void readObject(java.io.ObjectInputStream s)
			throws java.io.IOException, ClassNotFoundException {
		s.defaultReadObject();

		_listeners = new LinkedList<ChartsDataListener>();
		Serializables.smartRead(s, _listeners);
	}

	public Object clone() {
		final AbstractChartsModel clone;
		try {
			clone = (AbstractChartsModel) super.clone();
		} catch (CloneNotSupportedException e) {
			throw new InternalError();
		}
		clone._listeners = new LinkedList<ChartsDataListener>();
		return clone;
	}
}
