/** WaterfallPlotImpl.java.

	Purpose:
		
	Description:
		
	History:
		10:09:32 AM Jan 9, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart.impl;

import java.util.LinkedList;

import org.zkoss.chart.Charts;
import org.zkoss.chart.PlotData;
import org.zkoss.chart.Series;
import org.zkoss.chart.model.CategoryModel;
import org.zkoss.chart.model.ChartsModel;
import org.zkoss.chart.model.XYModel;

/**
 * A model implementation for waterfall chart
 * @author jumperchen
 *
 */
public class WaterfallPlotImpl extends PlotEngineImpl {
	public WaterfallPlotImpl(Charts chart) {
		super(chart);
	}

	public PlotData drawPlot(ChartsModel model) {
		if (model instanceof CategoryModel) {
			return drawCategoryModel((CategoryModel) model);
		} else if (model instanceof XYModel) {
			return drawXYModel((XYModel) model);
		}
		throw new IllegalArgumentException("Unsupported model type [" + model + "]");
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	protected PlotData drawCategoryModel(CategoryModel model) {
		PlotData plotData = getChart().getPlotData();
		int i = 0;
		for (Comparable<?> ser : model.getSeries()) {
			Series series = plotData.getSeries(i++);
			for (Comparable<?> cat : model.getCategories()) {
				series.addPoint(cat.toString(), model.getValue(ser, cat));
			}
			series.setName(ser.toString());
			if (!model.getCategories().isEmpty())
				plotData.getXAxis().setCategories(new LinkedList(model.getCategories()));
		}
		return plotData;
	}
}
