/** BubblePlotImpl.java.

	Purpose:
		
	Description:
		
	History:
		9:39:06 AM Jan 14, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart.impl;

import org.zkoss.chart.Charts;
import org.zkoss.chart.PlotData;
import org.zkoss.chart.model.ChartsModel;
import org.zkoss.chart.model.XYModel;
import org.zkoss.chart.model.XYZModel;

/**
 * A model implementation for bubble chart
 * @author jumperchen
 *
 */
public class BubblePlotImpl  extends PlotEngineImpl {
	public BubblePlotImpl(Charts chart) {
		super(chart);
	}

	public PlotData drawPlot(ChartsModel model) {
		if (model instanceof XYZModel) {
			return drawXYZModel((XYZModel) model);
		} else if (model instanceof XYModel) {
			return drawXYModel((XYModel) model);
		}
		throw new IllegalArgumentException("Unsupported model type [" + model + "]");
	}
}
