/** AreaSplinePlotImpl.java.

	Purpose:
		
	Description:
		
	History:
		4:50:34 PM Jan 13, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart.impl;

import org.zkoss.chart.Charts;
import org.zkoss.chart.PlotData;
import org.zkoss.chart.model.CategoryModel;
import org.zkoss.chart.model.ChartsModel;
import org.zkoss.chart.model.XYModel;

/**
 * A model implementation for area spline chart
 * @author jumperchen
 *
 */
public class AreaSplinePlotImpl extends PlotEngineImpl {
	public AreaSplinePlotImpl(Charts chart) {
		super(chart);
	}

	public PlotData drawPlot(ChartsModel model) {
		if (model instanceof CategoryModel) {
			return drawCategoryModel((CategoryModel) model);
		} else if (model instanceof XYModel) {
			return drawXYModel((XYModel) model);
		}
		throw new IllegalArgumentException("Unsupported model type [" + model + "]");
	}

}
