/** AreaRangePlotImpl.java.

	Purpose:
		
	Description:
		
	History:
		10:43:42 AM Jan 16, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart.impl;

import org.zkoss.chart.Charts;
import org.zkoss.chart.PlotData;
import org.zkoss.chart.model.ChartsModel;
import org.zkoss.chart.model.XYZModel;

/**
 * A model implementation for area range chart
 * @author jumperchen
 *
 */
public class AreaRangePlotImpl extends PlotEngineImpl {

	public AreaRangePlotImpl(Charts chart) {
		super(chart);
	}

	public PlotData drawPlot(ChartsModel model) {
		if (model instanceof XYZModel) {
			PlotData data = drawXYZModel((XYZModel) model);
			data.getXAxis().setType("datetime");
			return data;
		}
		throw new IllegalArgumentException("Unsupported model type [" + model + "]");
	}

}
