/** YAxisTitle.java.

	Purpose:
		
	Description:
		
	History:
		11:54:40 AM Mar 3, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart;

import org.zkoss.chart.util.DynamicalAttribute;

/**
 * A axis title option for YAxis
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author jumperchen
 */
public class YAxisTitle extends AxisTitle {

	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		rotation, text
	}

	/**
	 * Returns the rotation of the text in degrees. 0 is horizontal, 270 is
	 * vertical reading from bottom to top.
	 * <p>
	 * Default: 270.
	 */
	public Number getRotation() {
		return getAttr(Attrs.rotation, 270).asNumber();
	}

	/**
	 * Sets the rotation of the text in degrees. 0 is horizontal, 270 is
	 * vertical reading from bottom to top.
	 */
	public void setRotation(Number rotation) {
		setAttr(Attrs.rotation, rotation, 270);
	}

	/**
	 * Returns the actual text of the axis title. It can contain basic HTML text
	 * markup like &lt;b&gt;, &lt;i&gt; and spans with style.
	 * <p>
	 * Default: "Values".
	 */
	public String getText() {
		return getAttr(Attrs.text, "Values").asString();
	}

	/**
	 * Sets the actual text of the axis title. It can contain basic HTML text
	 * markup like &lt;b&gt;, &lt;i&gt; and spans with style.
	 */
	public void setText(String text) {
		setAttr(Attrs.text, text, "Values");
	}

}
