/** YAxisLabels.java.

	Purpose:
		
	Description:
		
	History:
		11:56:52 AM Mar 3, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
 */
package org.zkoss.chart;

import org.zkoss.chart.util.DynamicalAttribute;

/**
 * A axis labels option for YAxis
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author jumperchen
 */
public class YAxisLabels extends AxisLabels {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		x, y
	}

	/**
	 * Returns the x position offset of the label relative to the tick position
	 * on the axis.
	 * <p>
	 * Default: -8
	 */
	public Number getX() {
		return getAttr(Attrs.x, -8).asNumber();
	}

	/**
	 * Sets the x position offset of the label relative to the tick position on
	 * the axis.
	 * <p>
	 * Default: -8
	 */
	public void setX(Number x) {
		setAttr(Attrs.x, x, -8);
	}

	/**
	 * Returns the y position offset of the label relative to the tick position
	 * on the axis.
	 * <p>
	 * Default: 3
	 */
	public Number getY() {
		return getAttr(Attrs.y, 3).asNumber();
	}

	/**
	 * Sets the y position offset of the label relative to the tick position on
	 * the axis.
	 * <p>
	 * Default: 3
	 */
	public void setY(Number y) {
		setAttr(Attrs.y, y, 3);
	}
}
