/* States.java

	Purpose:
		
	Description:
		
	History:
		Mon, Feb 10, 2014  2:29:12 PM, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

 */
package org.zkoss.chart;

import org.zkoss.chart.plotOptions.SeriesPlotOptions;

/**
 * A wrapper object for all the series options in specific states.
 * 
 * @author RaymondChao
 */
public class States extends Optionable {
	private enum Attrs implements PlotAttribute {
		hover, select
	}

	/**
	 * Returns the hover state. If null, it will create a new one.
	 */
	public State getHover() {
		State hover = (State) getAttr(Attrs.hover);
		if (hover == null) {
			hover = new State("hover");
			setHover(hover);
		}
		return hover;
	}

	/**
	 * Sets the hover state.
	 */
	public void setHover(State hover) {
		setAttr(Attrs.hover, hover);
	}

	/**
	 * Returns the appearance of the point marker when selected. In order to
	 * allow a point to be selected, set
	 * {@link SeriesPlotOptions#setAllowPointSelect(boolean)} to true.
	 */
	public State getSelect() {
		State select = (State) getAttr(Attrs.select);
		if (select == null) {
			select = new State("select");
			setSelect(select);
		}
		return select;
	}

	/**
	 * Sets the appearance of the point marker when selected. In order to
	 * allow a point to be selected, set
	 * {@link SeriesPlotOptions#setAllowPointSelect(boolean)} to true.
	 */
	public void setSelect(State select) {
		setAttr(Attrs.select, select);
	}

}
