/** Shadow.java.

	Purpose:
		
	Description:
		
	History:
		17:15:54 PM Feb 12, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
 */
package org.zkoss.chart;

import org.zkoss.json.JSONObject;

/**
 * A shadow option to set for the chart
 * 
 * @author jumperchen
 * 
 */
public class Shadow extends Optionable {
	private enum Attrs implements PlotAttribute {
		color,
		offsetX,
		offsetY,
		opacity,
		width
	}
	/**
	 * No shadow at all
	 */
	public static Shadow NONE = new EmptyShadow();
	
	private static class EmptyShadow extends Shadow {
		public String toJSONString() {
			return "false";
		}
	}

	/**
	 * Returns the color of the shadow
	 * <p> Default: black
	 */
	public Color getColor() {
		if (!containsKey(Attrs.color)) {
			setColor("black");
		}
		return (Color) getAttr(Attrs.color);
	}

	/**
	 * Sets the color of the shadow
	 */
	public void setColor(Color color) {
		setAttr(Attrs.color, color, NOT_NULL_VALUE);
	}

	/**
	 * Sets the color of the shadow
	 */
	public void setColor(String color) {
		setColor(new Color(color));
	}

	/**
	 * Sets the color of the shadow
	 */
	public void setColor(LinearGradient color) {
		setColor(new Color(color));
	}

	/**
	 * Sets the color of the shadow
	 */
	public void setColor(RadialGradient color) {
		setColor(new Color(color));
	}
	
	/**
	 * Sets the offset X of the shadow
	 */
	public void setOffsetX(int offsetX) {
		setAttr(Attrs.offsetX, offsetX, 1);
	}
	
	/**
	 * Returns the offset X of the shadow
	 * <p> Default: 1
	 */
	public Number getOffsetX() {
		return getAttr(Attrs.offsetX, 1).asNumber();
	}
	
	/**
	 * Sets the offset Y of the shadow
	 */
	public void setOffsetY(Number offsetY) {
		setAttr(Attrs.offsetY, offsetY, 1);
	}
	
	/**
	 * Returns the offset Y of the shadow
	 * <p> Default: 1
	 */
	public Number getOffsetY() {
		return getAttr(Attrs.offsetY, 1).asNumber();
	}
	
	/**
	 * Sets the opacity of the shadow
	 * @param opacity
	 */
	public void setOpacity(Number opacity) {
		setAttr(Attrs.opacity, opacity, NOT_NULL_VALUE);
	}
	
	/**
	 * Returns the opacity of the shadow.
	 * <p>Default: 0.15 / {@link #getWidth()}
	 */
	public Number getOpacity() {
		return getAttr(Attrs.opacity, 0.15/ (Integer)getWidth()).asNumber();
	}
	
	/**
	 * Sets the width of the shadow
	 */
	public void setWidth(Number width) {
		setAttr(Attrs.width, width, 3);
	}
	
	/**
	 * Returns the width of the shadow
	 * <p> Default: 3
	 */
	public Number getWidth() {
		return getAttr(Attrs.width, 3).asNumber();
	}
	public String toJSONString() {
		if(options.isEmpty()) {
			return "true";
		} else
			return JSONObject.toJSONString(options);
	}
}
