/* ResetZoomButton.java

	Purpose:
		
	Description:
		
	History:
		Tue, Jan 28, 2014 12:21:24 PM, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

 */
package org.zkoss.chart;

import java.util.Map;

import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.lang.Generics;

/**
 * The button that appears after a selection zoom, allowing the user to reset
 * zoom.
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author jumperchen
 * @author RaymondChao
 */
public class ResetZoomButton extends Optionable {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		position, relativeTo, theme
	}

	/**
	 * Returns the position of the button. This is an object that can hold the
	 * properties align, verticalAlign, x and y.
	 */
	public Position getPosition() {
		return (Position) getAttr(Attrs.position, null).asValue();
	}

	/**
	 * Sets the position of the button. This is an object that can hold the
	 * properties align, verticalAlign, x and y.
	 */
	public void setPosition(Position position) {
		setAttr(Attrs.position, position);
	}

	/**
	 * Returns what box to align the button to. Can be either "plot" or "chart".
	 */
	public String getRelativeTo() {
		return getAttr(Attrs.relativeTo, "plot").asString();
	}

	/**
	 * Sets what frame the button should be placed related to. Can be either
	 * "plot" or "chart".
	 * <p>
	 * Defaults to plot.
	 */
	public void setRelativeTo(String relativeTo) {
		if (!("plot".equals(relativeTo) || "chart".equals(relativeTo)))
			throw new IllegalArgumentException("Unsupported value: ["
					+ relativeTo + "]");
		setAttr(Attrs.relativeTo, relativeTo, "plot");
	}

	/**
	 * Returns a collection of attributes for the button. The object takes SVG
	 * attributes like <code>fill</code>, <code>stroke</code>,
	 * <code>stroke-width</code> or <code>r</code>, the border radius. The theme
	 * also supports <code>style</code>, a collection of CSS properties for the
	 * text. Equivalent attributes for the hover state are given in
	 * <code>theme.states.hover</code>.
	 */
	public <K, V> Map<K, V> getTheme() {
		return Generics.cast(getAttr(Attrs.theme, null).asValue());
	}

	/**
	 * Sets a collection of attributes for the button. The object takes SVG
	 * attributes like <code>fill</code>, <code>stroke</code>,
	 * <code>stroke-width</code> or <code>r</code>, the border radius. The theme
	 * also supports <code>style</code>, a collection of CSS properties for the
	 * text. Equivalent attributes for the hover state are given in
	 * <code>theme.states.hover</code>.
	 */
	public <K, V> void setTheme(Map<K, V> theme) {
		setAttr(Attrs.theme, theme);
	}

}