/** Position.java.

	Purpose:
		
	Description:
		
	History:
		12:00:44 PM Feb 6, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
 */
package org.zkoss.chart;

import org.zkoss.chart.util.DynamicalAttribute;

/**
 * A position option to specify the position for buttons or labels.
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author jumperchen
 */
public class Position extends Optionable {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		x, y, align, verticalAlign
	}

	public Position() {
	}

	public Position(Number x, Number y) {
		setX(x);
		setY(y);
	}

	public Position(Number x, Number y, String align, String verticalAlign) {
		setX(x);
		setY(y);
		setAlign(align);
		setVerticalAlign(verticalAlign);
	}

	/**
	 * Sets the x offset.
	 * 
	 * @param x
	 */
	public void setX(Number x) {
		setAttr(Attrs.x, x);
	}

	/**
	 * Returns the x offset.
	 */
	public Number getX() {
		return (Number) getAttr(Attrs.x, null).asValue();
	}

	/**
	 * Sets the y offset.
	 * 
	 * @param y
	 */
	public void setY(Number y) {
		setAttr(Attrs.y, y);
	}

	/**
	 * Returns the y offset.
	 */
	public Number getY() {
		return (Number) getAttr(Attrs.y, null).asValue();
	}

	/**
	 * Sets the alignment of the position
	 */
	public void setAlign(String align) {
		setAttr(Attrs.align, align);
	}

	/**
	 * Returns the alignment of the position
	 * <p>Default: null
	 */
	public String getAlign() {
		return getAttr(Attrs.align, null).asString();
	}

	/**
	 * Sets the vertical alignment of the position
	 */
	public void setVerticalAlign(String verticalAlign) {
		setAttr(Attrs.verticalAlign, verticalAlign);
	}

	/**
	 * Returns the vertical alignment of the position
	 * <p>Default: null
	 */
	public String getVerticalAlign() {
		return getAttr(Attrs.verticalAlign, null).asString();
	}
}
