/** PlotEngine.java.

	Purpose:
		
	Description:
		
	History:
		3:18:05 PM Jan 8, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart;

import org.zkoss.chart.model.ChartsModel;

/**
 * A plot engine interface for chart model with Highcharts component
 * @author jumperchen
 */
public interface PlotEngine {
	/**
	 * Returns the plot data format which is a JSON string.
	 * <p> Please refer to <a href="http://api.highcharts.com/highcharts">Highcharts's
	 * chart options</a>
	 * <p>
	 * For example, the returned value in JSON string will be similar to this.
<pre><code>
	{
            xAxis: {
                categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
                    'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']
            },
            series: [{
                name: 'Tokyo',
                data: [7.0, 6.9, 9.5, 14.5, 18.2, 21.5, 25.2, 26.5, 23.3, 18.3, 13.9, 9.6]
            }, {
                name: 'New York',
                data: [-0.2, 0.8, 5.7, 11.3, 17.0, 22.0, 24.8, 24.1, 20.1, 14.1, 8.6, 2.5]
            }, {
                name: 'Berlin',
                data: [-0.9, 0.6, 3.5, 8.4, 13.5, 17.0, 18.6, 17.9, 14.3, 9.0, 3.9, 1.0]
            }, {
                name: 'London',
                data: [3.9, 4.2, 5.7, 8.5, 11.9, 15.2, 17.0, 16.6, 14.2, 10.3, 6.6, 4.8]
            }]
        });
    }
</code></pre>
	 * @param model
	 */
	public PlotData drawPlot(ChartsModel model);
}
