/* PaneBackground.java

	Purpose:
		
	Description:
		
	History:
		Mon, Jan 27, 2014 11:36:08 AM, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

 */
package org.zkoss.chart;

import org.zkoss.chart.util.DynamicalAttribute;

/**
 * A option of background for Pane.
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author RaymondChao
 * @author jumperchen
 */
public class PaneBackground extends Optionable {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		backgroundColor,
		borderColor,
		borderWidth,
		innerRadius,
		innerWidth,
		outerRadius,
		outerWidth,
	}

	/**
	 * Returns the background gradient
	 * <p>
	 * Default:
	 * 
	 * <pre>
	 * {
	 * 		linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
	 * 		stops: [
	 * 			[0, '#FFF'],
	 * 			[1, '#DDD']
	 * 		]
	 *}
	 * </pre>
	 */
	public Color getBackgroundColor() {
		if (!containsKey(Attrs.backgroundColor)) {
			LinearGradient linearGradient = new LinearGradient(0, 0, 0, 1);
			linearGradient.setStops("#FFF", "#DDD");
			setBackgroundColor(linearGradient);
		}
		return (Color) getAttr(Attrs.backgroundColor);
	}

	/**
	 * Sets the background color
	 */
	public void setBackgroundColor(Color color) {
		setAttr(Attrs.backgroundColor, color, NOT_NULL_VALUE);
	}

	/**
	 * Sets the background color
	 */
	public void setBackgroundColor(String color) {
		setBackgroundColor(new Color(color));
	}

	/**
	 * Sets the background color
	 */
	public void setBackgroundColor(LinearGradient color) {
		setBackgroundColor(new Color(color));
	}

	/**
	 * Sets the background color
	 */
	public void setBackgroundColor(RadialGradient color) {
		setBackgroundColor(new Color(color));
	}
	
	/**
	 * Returns the border width.
	 * <p> Default: 0.
	 */
	public Number getBorderWidth() {
		return getAttr(Attrs.borderWidth, 0).asNumber();
	}

	/**
	 * Sets the border width.
	 * <p> Default: 0.
	 */
	public void setBorderWidth(Number borderWidth) {
		setAttr(Attrs.borderWidth, borderWidth, 0);
	}

	/**
	 * Returns the inner radius
	 * <p> Default: 0
	 */
	public Object getInnerRadius() {
		return getAttr(Attrs.innerRadius, 0).asValue();
	}

	/**
	 * Sets the inner radius.
	 */
	public void setInnerRadius(Number innerRadius) {
		setAttr(Attrs.innerRadius, innerRadius, 0);
	}

	/**
	 * Sets the inner radius.
	 */
	public void setInnerRadius(String innerRadius) {
		setAttr(Attrs.innerRadius, innerRadius, 0);
	}

	/**
	 * Returns the inner width.
	 * <p> Default: 0
	 */
	public Number getInnerWidth() {
		return getAttr(Attrs.innerWidth, 0).asNumber();
	}

	/**
	 * Sets the inner width
	 */
	public void setInnerWidth(Number innerWidth) {
		setAttr(Attrs.innerWidth, innerWidth, 0);
	}

	/**
	 * Returns the outer radius.
	 * <p> Default: 105%
	 */
	public Object getOuterRadius() {
		return getAttr(Attrs.outerRadius, "105%").asString();
	}

	/**
	 * Sets the outer radius
	 */
	public void setOuterRadius(String outerRadius) {
		setAttr(Attrs.outerRadius, outerRadius, "105%");
	}

	/**
	 * Sets the outer radius
	 */
	public void setOuterRadius(Number outerRadius) {
		setAttr(Attrs.outerRadius, outerRadius, "105%");
	}
	
	/**
	 * Returns the outer width.
	 * <p>Default: 0
	 */
	public Number getOuterWidth() {
		return getAttr(Attrs.outerWidth, 0).asNumber();
	}

	/**
	 * Sets the outer width
	 * @param outerWidth
	 */
	public void setOuterWidth(Number outerWidth) {
		setAttr(Attrs.outerWidth, outerWidth, 0);
	}
}
